/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.rabbitmq.fault;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.rabbitmq.ClientHolder;
import io.smallrye.reactive.messaging.rabbitmq.IncomingRabbitMQMessage;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnector;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.rabbitmq.RabbitMQRejectMetadata;
import io.smallrye.reactive.messaging.rabbitmq.fault.RabbitMQFailureHandler;
import io.smallrye.reactive.messaging.rabbitmq.i18n.RabbitMQLogging;
import io.vertx.mutiny.core.Context;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class RabbitMQRequeue
implements RabbitMQFailureHandler {
    private final String channel;

    public RabbitMQRequeue(String channel) {
        this.channel = channel;
    }

    @Override
    public <V> CompletionStage<Void> handle(IncomingRabbitMQMessage<V> msg, Metadata metadata, Context context, Throwable reason) {
        RabbitMQLogging.log.nackedIgnoreMessage(this.channel);
        RabbitMQLogging.log.fullIgnoredFailure(reason);
        boolean requeue = Optional.ofNullable(metadata).flatMap(md -> md.get(RabbitMQRejectMetadata.class)).map(RabbitMQRejectMetadata::isRequeue).orElse(true);
        return ClientHolder.runOnContext(context, msg, m -> m.rejectMessage(reason, requeue));
    }

    @ApplicationScoped
    @Identifier(value="requeue")
    public static class Factory
    implements RabbitMQFailureHandler.Factory {
        @Override
        public RabbitMQFailureHandler create(RabbitMQConnectorIncomingConfiguration config, RabbitMQConnector connector) {
            return new RabbitMQRequeue(config.getChannel());
        }
    }
}

