/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.AdaptTo;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Wrapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Reference
implements Serializable {
    private String className;
    private String name;
    private ReferenceType type;
    private String graphQLClassName;
    private AdaptTo adaptTo = null;
    private AdaptWith adaptWith = null;
    private Map<String, Reference> classParametrizedTypes;
    private Map<String, Reference> parentClassParametrizedTypes;
    private boolean addParametrizedTypeNameExtension;
    private List<DirectiveInstance> directiveInstances;
    private Wrapper wrapper = null;

    public Reference() {
    }

    protected Reference(String className, String name, ReferenceType type) {
        this.className = className;
        this.name = name;
        this.type = type;
    }

    private Reference(Builder builder) {
        this.className = builder.className;
        this.name = builder.name;
        this.type = builder.type;
        this.graphQLClassName = builder.graphQLClassName;
        this.adaptTo = builder.adaptTo;
        this.adaptWith = builder.adaptWith;
        this.classParametrizedTypes = builder.classParametrizedTypes;
        this.parentClassParametrizedTypes = builder.parentClassParametrizedTypes;
        this.addParametrizedTypeNameExtension = builder.addParametrizedTypeNameExtension;
        this.directiveInstances = builder.directiveInstances;
        this.wrapper = builder.wrapper;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReferenceType getType() {
        return this.type;
    }

    public void setType(ReferenceType type) {
        this.type = type;
    }

    public String getGraphQLClassName() {
        if (this.graphQLClassName != null) {
            return this.graphQLClassName;
        }
        return this.className;
    }

    public void setGraphQLClassName(String graphQLClassName) {
        this.graphQLClassName = graphQLClassName;
    }

    public AdaptTo getAdaptTo() {
        return this.adaptTo;
    }

    public void setAdaptTo(AdaptTo adaptTo) {
        this.adaptTo = adaptTo;
    }

    public boolean isAdaptingTo() {
        return this.adaptTo != null;
    }

    public AdaptWith getAdaptWith() {
        return this.adaptWith;
    }

    public void setAdaptWith(AdaptWith adaptWith) {
        this.adaptWith = adaptWith;
    }

    public boolean isAdaptingWith() {
        return this.adaptWith != null;
    }

    public Map<String, Reference> getAllParametrizedTypes() {
        if (this.classParametrizedTypes == null && this.parentClassParametrizedTypes == null) {
            return new HashMap<String, Reference>();
        }
        if (this.classParametrizedTypes == null) {
            return this.parentClassParametrizedTypes;
        }
        if (this.parentClassParametrizedTypes == null) {
            return this.classParametrizedTypes;
        }
        Stream combinedStream = Stream.concat(this.classParametrizedTypes.entrySet().stream(), this.parentClassParametrizedTypes.entrySet().stream());
        return combinedStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Reference> getClassParametrizedTypes() {
        return this.classParametrizedTypes;
    }

    public void setClassParametrizedTypes(Map<String, Reference> classParametrizedTypes) {
        this.classParametrizedTypes = classParametrizedTypes;
    }

    public boolean hasClassParameterizedTypes() {
        return this.getAllParametrizedTypes() != null && !this.getAllParametrizedTypes().isEmpty();
    }

    public Reference getClassParametrizedType(String name) {
        if (this.hasClassParameterizedTypes()) {
            return this.getAllParametrizedTypes().get(name);
        }
        return null;
    }

    public Map<String, Reference> getParentClassParametrizedTypes() {
        return this.parentClassParametrizedTypes;
    }

    public void setParentClassParametrizedTypes(Map<String, Reference> parentClassParametrizedTypes) {
        this.parentClassParametrizedTypes = parentClassParametrizedTypes;
    }

    public boolean isAddParametrizedTypeNameExtension() {
        return this.addParametrizedTypeNameExtension;
    }

    public void setAddParametrizedTypeNameExtension(boolean addParametrizedTypeNameExtension) {
        this.addParametrizedTypeNameExtension = addParametrizedTypeNameExtension;
    }

    public List<DirectiveInstance> getDirectiveInstances() {
        return this.directiveInstances;
    }

    public boolean hasDirectiveInstances() {
        return this.directiveInstances != null && !this.directiveInstances.isEmpty();
    }

    public void setDirectiveInstances(List<DirectiveInstance> directiveInstances) {
        this.directiveInstances = directiveInstances;
    }

    public void addDirectiveInstance(DirectiveInstance directiveInstance) {
        this.directiveInstances.add(directiveInstance);
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public boolean hasWrapper() {
        return this.wrapper != null;
    }

    public String toString() {
        return "Reference{className=" + this.className + ", name=" + this.name + ", type=" + this.type + ", graphQLClassName=" + this.graphQLClassName + ", adaptTo=" + this.adaptTo + ", adaptWith=" + this.adaptWith + ", directiveInstances=" + this.directiveInstances + ", classParametrizedTypes" + this.classParametrizedTypes + ", extendedClassParametrizedTypes" + this.parentClassParametrizedTypes + ", wrapper=" + this.wrapper + "}";
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.className);
        hash = 97 * hash + Objects.hashCode(this.name);
        hash = 97 * hash + Objects.hashCode((Object)this.type);
        hash = 97 * hash + Objects.hashCode(this.graphQLClassName);
        hash = 97 * hash + Objects.hashCode(this.adaptTo);
        hash = 97 * hash + Objects.hashCode(this.adaptWith);
        hash = 97 * hash + Objects.hashCode(this.directiveInstances);
        hash = 97 * hash + Objects.hashCode(this.classParametrizedTypes);
        hash = 97 * hash + Objects.hashCode(this.parentClassParametrizedTypes);
        hash = 97 * hash + Objects.hashCode(this.wrapper);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reference other = (Reference)obj;
        if (!Objects.equals(this.className, other.className)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.graphQLClassName, other.graphQLClassName)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (!Objects.equals(this.adaptTo, other.adaptTo)) {
            return false;
        }
        if (!Objects.equals(this.adaptWith, other.adaptWith)) {
            return false;
        }
        if (!Objects.equals(this.directiveInstances, other.directiveInstances)) {
            return false;
        }
        if (!Objects.equals(this.classParametrizedTypes, other.classParametrizedTypes)) {
            return false;
        }
        if (!Objects.equals(this.parentClassParametrizedTypes, other.parentClassParametrizedTypes)) {
            return false;
        }
        return Objects.equals(this.wrapper, other.wrapper);
    }

    public static class Builder {
        private String className;
        private String name;
        private ReferenceType type;
        private String graphQLClassName;
        private AdaptTo adaptTo = null;
        private AdaptWith adaptWith = null;
        private Map<String, Reference> classParametrizedTypes;
        private Map<String, Reference> parentClassParametrizedTypes;
        private boolean addParametrizedTypeNameExtension;
        private List<DirectiveInstance> directiveInstances;
        private Wrapper wrapper;

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(ReferenceType type) {
            this.type = type;
            return this;
        }

        public Builder graphQLClassName(String graphQLClassName) {
            this.graphQLClassName = graphQLClassName;
            return this;
        }

        public Builder adaptTo(AdaptTo adaptTo) {
            this.adaptTo = adaptTo;
            return this;
        }

        public Builder adaptWith(AdaptWith adaptWith) {
            this.adaptWith = adaptWith;
            return this;
        }

        public Builder classParametrizedTypes(Map<String, Reference> classParametrizedTypes) {
            this.classParametrizedTypes = classParametrizedTypes;
            return this;
        }

        public Builder extendedClassParametrizedTypes(Map<String, Reference> extendedClassParametrizedTypes) {
            this.parentClassParametrizedTypes = extendedClassParametrizedTypes;
            return this;
        }

        public Builder addParametrizedTypeNameExtension(boolean addParametrizedTypeNameExtension) {
            this.addParametrizedTypeNameExtension = addParametrizedTypeNameExtension;
            return this;
        }

        public Builder directiveInstances(List<DirectiveInstance> directiveInstances) {
            this.directiveInstances = directiveInstances;
            return this;
        }

        public Builder wrapper(Wrapper wrapper) {
            this.wrapper = wrapper;
            return this;
        }

        public Builder reference(Reference reference) {
            this.className(reference.getClassName());
            this.name(reference.getName());
            this.type(reference.getType());
            this.graphQLClassName(reference.getGraphQLClassName());
            this.adaptTo(reference.getAdaptTo());
            this.adaptWith(reference.getAdaptWith());
            this.classParametrizedTypes(reference.getClassParametrizedTypes());
            this.addParametrizedTypeNameExtension(reference.isAddParametrizedTypeNameExtension());
            this.directiveInstances(reference.getDirectiveInstances());
            this.wrapper(reference.getWrapper());
            return this;
        }

        public Reference build() {
            return new Reference(this);
        }
    }
}

