/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.schema.model.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dataloader.BatchLoaderEnvironment;

public class BatchLoaderHelper {
    public static final String ARGUMENTS = "arguments";
    public static final String DATA_FETCHING_ENVIRONMENT = "dataFetchingEnvironment";

    public String getName(Operation operation) {
        return operation.getSourceFieldOn().getName() + "_" + operation.getName();
    }

    public <K> Map<String, Object> getBatchContext(List<K> keys, BatchLoaderEnvironment ble) {
        HashMap<String, Object> batchContext = new HashMap<String, Object>();
        List keyContextsList = ble.getKeyContextsList();
        ArrayList<List<K>> finalArguments = new ArrayList<List<K>>();
        finalArguments.add(keys);
        if (keyContextsList != null && !keyContextsList.isEmpty()) {
            Map keyContexts = (Map)keyContextsList.get(0);
            List otherarguments = (List)keyContexts.get(ARGUMENTS);
            finalArguments.addAll(otherarguments);
            batchContext.putAll(keyContexts);
            batchContext.put(ARGUMENTS, finalArguments);
        }
        return batchContext;
    }

    public Object[] getArguments(Map<String, Object> batchContext) {
        List arguments = (List)batchContext.get(ARGUMENTS);
        return arguments.toArray();
    }

    public DataFetchingEnvironment getDataFetchingEnvironment(Map<String, Object> batchContext) {
        return (DataFetchingEnvironment)batchContext.get(DATA_FETCHING_ENVIRONMENT);
    }
}

