/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.execution.Classes;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ServiceLoader;

public interface ClassloadingService {
    public static final ServiceLoader<ClassloadingService> classloadingServices = ServiceLoader.load(ClassloadingService.class);
    public static final ClassloadingService classloadingService = ClassloadingService.load();

    public static ClassloadingService get() {
        return classloadingService;
    }

    public static ClassloadingService load() {
        ClassloadingService cls;
        try {
            cls = classloadingServices.iterator().next();
        }
        catch (Exception ex) {
            cls = new DefaultClassloadingService();
        }
        SmallRyeGraphQLServerLogging.log.usingClassLoadingService(cls.getName());
        return cls;
    }

    public String getName();

    default public Class<?> loadClass(String className) {
        try {
            if (Classes.isPrimitive(className)) {
                return Classes.getPrimativeClassType(className);
            }
            return AccessController.doPrivileged(() -> {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    try {
                        return this.loadClass(className, loader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return this.loadClass(className, ClassloadingService.class.getClassLoader());
            });
        }
        catch (ClassNotFoundException | PrivilegedActionException pae) {
            throw SmallRyeGraphQLServerMessages.msg.canNotLoadClass(className, pae);
        }
    }

    default public Class<?> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        Class<?> c = Class.forName(className, false, loader);
        return c;
    }

    public static class DefaultClassloadingService
    implements ClassloadingService {
        @Override
        public String getName() {
            return "TCCL (default)";
        }
    }
}

