/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.validation;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.SourceLocation;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BeanValidationError
implements GraphQLError {
    private final ConstraintViolation<?> violation;
    private final List<NamedNode<?>> requestedPath;

    public BeanValidationError(ConstraintViolation<?> violation, List<NamedNode<?>> requestedPath) {
        this.violation = violation;
        this.requestedPath = requestedPath;
    }

    public ErrorClassification getErrorType() {
        return ErrorType.ValidationError;
    }

    public String getMessage() {
        return "validation failed: " + this.violation.getPropertyPath() + " " + this.violation.getMessage();
    }

    public List<SourceLocation> getLocations() {
        return this.requestedPath.stream().map(Node::getSourceLocation).collect(Collectors.toList());
    }

    public List<Object> getPath() {
        return this.requestedPath.stream().map(argument -> argument.getName()).collect(Collectors.toList());
    }

    public Map<String, Object> getExtensions() {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        extensions.put("violation.message", this.violation.getMessage());
        extensions.put("violation.propertyPath", BeanValidationError.toStream(this.violation.getPropertyPath()).flatMap(this::items).collect(Collectors.toList()));
        extensions.put("violation.invalidValue", this.violation.getInvalidValue());
        extensions.put("violation.constraint", this.getConstraintAttributes());
        return extensions;
    }

    private Stream<String> items(Path.Node node) {
        if (node.getIndex() == null) {
            return Stream.of(node.getName());
        }
        return Stream.of(node.getIndex().toString(), node.getName());
    }

    private Map<String, Object> getConstraintAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.violation.getConstraintDescriptor().getAttributes());
        attributes.computeIfPresent("groups", BeanValidationError::classNames);
        attributes.computeIfPresent("payload", BeanValidationError::classNames);
        return attributes;
    }

    private static Object classNames(String key, Object oldValue) {
        return Stream.of((Class[])oldValue).map(Class::getName).collect(Collectors.toList());
    }

    static <T> Stream<T> toStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

