/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.spi.ClassloadingService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class CollectionCreator {
    private static final ClassloadingService classloadingService = ClassloadingService.get();

    public static Collection<?> newCollection(String className, int initialSize) {
        Class<?> type = classloadingService.loadClass(className);
        return CollectionCreator.newCollection(type, initialSize);
    }

    private static Collection<?> newCollection(Class<?> type, int initialSize) {
        if (type.isAssignableFrom(ArrayList.class)) {
            return new ArrayList(initialSize);
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return new HashSet((int)((double)initialSize / 0.75 + 1.0));
        }
        if (type.isAssignableFrom(ArrayDeque.class)) {
            return new ArrayDeque(initialSize);
        }
        if (type.isAssignableFrom(TreeSet.class)) {
            return new TreeSet();
        }
        try {
            return (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            SmallRyeGraphQLServerLogging.log.noArgConstructorMissing(type.getName());
            throw new IllegalArgumentException("Could not create collection if type " + type.getName());
        }
    }
}

