/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.build.JwtEncryptionBuilder;
import io.smallrye.jwt.build.JwtSignatureBuilder;
import io.smallrye.jwt.build.JwtSignatureException;
import io.smallrye.jwt.build.impl.ImplMessages;
import io.smallrye.jwt.build.impl.JwtBuildUtils;
import io.smallrye.jwt.build.impl.JwtEncryptionImpl;
import io.smallrye.jwt.build.impl.JwtSignatureImpl;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.json.JsonNumber;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.keys.X509Util;

class JwtClaimsBuilderImpl
extends JwtSignatureImpl
implements JwtClaimsBuilder,
JwtSignatureBuilder {
    JwtClaimsBuilderImpl() {
    }

    JwtClaimsBuilderImpl(String jsonLocation) {
        super(JwtClaimsBuilderImpl.parseJsonToClaims(jsonLocation));
    }

    JwtClaimsBuilderImpl(Map<String, Object> claimsMap) {
        super(JwtClaimsBuilderImpl.fromMapToJwtClaims(claimsMap));
    }

    private static JwtClaims fromMapToJwtClaims(Map<String, Object> claimsMap) {
        JwtClaims claims = new JwtClaims();
        Map newMap = (Map)JwtClaimsBuilderImpl.prepareValue(claimsMap);
        for (Map.Entry entry : newMap.entrySet()) {
            claims.setClaim((String)entry.getKey(), entry.getValue());
        }
        return claims;
    }

    @Override
    public JwtClaimsBuilder claim(String name, Object value) {
        this.claims.setClaim(name, JwtClaimsBuilderImpl.prepareValue(value));
        return this;
    }

    @Override
    public JwtClaimsBuilder issuer(String issuer) {
        this.claims.setIssuer(issuer);
        return this;
    }

    @Override
    public JwtClaimsBuilder audience(String audience) {
        return this.audience(Collections.singleton(audience));
    }

    @Override
    public JwtClaimsBuilder audience(Set<String> audiences) {
        this.claims.setAudience(audiences.stream().collect(Collectors.toList()));
        return this;
    }

    @Override
    public JwtClaimsBuilder subject(String subject) {
        this.claims.setSubject(subject);
        return this;
    }

    @Override
    public JwtClaimsBuilder upn(String upn) {
        this.claims.setClaim(Claims.upn.name(), (Object)upn);
        return this;
    }

    @Override
    public JwtClaimsBuilder preferredUserName(String preferredUserName) {
        this.claims.setClaim(Claims.preferred_username.name(), (Object)preferredUserName);
        return this;
    }

    @Override
    public JwtClaimsBuilder issuedAt(long issuedAt) {
        this.claims.setIssuedAt(NumericDate.fromSeconds((long)issuedAt));
        return this;
    }

    @Override
    public JwtClaimsBuilder expiresAt(long expiresAt) {
        this.claims.setExpirationTime(NumericDate.fromSeconds((long)expiresAt));
        return this;
    }

    @Override
    public JwtClaimsBuilder expiresIn(long expiresIn) {
        this.tokenLifespan = expiresIn;
        return this;
    }

    @Override
    public JwtClaimsBuilder groups(String group) {
        return this.groups(Collections.singleton(group));
    }

    @Override
    public JwtClaimsBuilder groups(Set<String> groups) {
        this.claims.setClaim(Claims.groups.name(), groups.stream().collect(Collectors.toList()));
        return this;
    }

    @Override
    public JwtSignatureBuilder jws() {
        return this;
    }

    @Override
    public JwtSignatureBuilder header(String name, Object value) {
        if ("alg".equals(name)) {
            return this.algorithm(JwtClaimsBuilderImpl.toSignatureAlgorithm((String)value));
        }
        this.headers.put(name, value);
        return this;
    }

    @Override
    public JwtSignatureBuilder algorithm(SignatureAlgorithm algorithm) {
        this.headers.put("alg", algorithm.name());
        return this;
    }

    @Override
    public JwtSignatureBuilder keyId(String keyId) {
        this.headers.put("kid", keyId);
        return this;
    }

    @Override
    public JwtSignatureBuilder thumbprint(X509Certificate cert) {
        this.headers.put("x5t", X509Util.x5t((X509Certificate)cert));
        return this;
    }

    @Override
    public JwtSignatureBuilder thumbprintS256(X509Certificate cert) {
        this.headers.put("x5t#S256", X509Util.x5tS256((X509Certificate)cert));
        return this;
    }

    @Override
    public JwtEncryptionBuilder innerSign(PrivateKey signingKey) throws JwtSignatureException {
        return super.innerSign(signingKey);
    }

    @Override
    public JwtEncryptionBuilder innerSign(SecretKey signingKey) throws JwtSignatureException {
        return super.innerSign(signingKey);
    }

    @Override
    public JwtEncryptionBuilder innerSign() throws JwtSignatureException {
        return super.innerSign();
    }

    @Override
    public String json() {
        JwtBuildUtils.setDefaultJwtClaims(this.claims, this.tokenLifespan);
        return this.claims.toJson();
    }

    @Override
    public JwtEncryptionBuilder jwe() {
        JwtBuildUtils.setDefaultJwtClaims(this.claims, this.tokenLifespan);
        return new JwtEncryptionImpl(this.claims.toJson());
    }

    private static Object prepareValue(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(o -> JwtClaimsBuilderImpl.prepareValue(o)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                newMap.put(entry.getKey(), JwtClaimsBuilderImpl.prepareValue(entry.getValue()));
            }
            return newMap;
        }
        if (value instanceof JsonValue) {
            return JwtClaimsBuilderImpl.convertJsonValue((JsonValue)value);
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value;
        }
        return value.toString();
    }

    private static Object convertJsonValue(JsonValue jsonValue) {
        if (jsonValue instanceof JsonString) {
            String jsonString = jsonValue.toString();
            return jsonString.toString().substring(1, jsonString.length() - 1);
        }
        if (jsonValue instanceof JsonNumber) {
            JsonNumber jsonNumber = (JsonNumber)jsonValue;
            if (jsonNumber.isIntegral()) {
                return jsonNumber.longValue();
            }
            return jsonNumber.doubleValue();
        }
        if (jsonValue == JsonValue.TRUE) {
            return true;
        }
        if (jsonValue == JsonValue.FALSE) {
            return false;
        }
        return null;
    }

    private static JwtClaims parseJsonToClaims(String jsonLocation) {
        return JwtBuildUtils.parseJwtClaims(jsonLocation);
    }

    private static SignatureAlgorithm toSignatureAlgorithm(String value) {
        try {
            return SignatureAlgorithm.fromAlgorithm((String)value);
        }
        catch (Exception ex) {
            throw ImplMessages.msg.unsupportedSignatureAlgorithm(value, ex);
        }
    }
}

