/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.mechanism;

import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.mechanism.MechanismLogging;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTParser;
import java.security.Principal;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class JWTHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    private JWTAuthContextInfo authContextInfo;
    @Inject
    private JWTParser jwtParser;
    @Inject
    private PrincipalProducer producer;

    public JWTHttpAuthenticationMechanism() {
    }

    public JWTHttpAuthenticationMechanism(JWTAuthContextInfo authContextInfo, JWTParser jwtParser, PrincipalProducer producer) {
        this.authContextInfo = authContextInfo;
        this.jwtParser = jwtParser;
        this.producer = producer;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        BearerTokenExtractor extractor = new BearerTokenExtractor(request, this.authContextInfo);
        String bearerToken = extractor.getBearerToken();
        if (bearerToken != null) {
            try {
                JsonWebToken jwtPrincipal = this.jwtParser.parse(bearerToken);
                this.producer.setJsonWebToken(jwtPrincipal);
                Set groups = jwtPrincipal.getGroups();
                MechanismLogging.log.success();
                return httpMessageContext.notifyContainerAboutLogin((Principal)jwtPrincipal, groups);
            }
            catch (Exception e) {
                MechanismLogging.log.unableToValidateBearerToken(e);
                return httpMessageContext.responseUnauthorized();
            }
        }
        MechanismLogging.log.noUsableBearerTokenFound();
        return httpMessageContext.isProtected() ? httpMessageContext.responseUnauthorized() : httpMessageContext.doNothing();
    }

    private static class BearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private final HttpServletRequest request;

        BearerTokenExtractor(HttpServletRequest request, JWTAuthContextInfo authContextInfo) {
            super(authContextInfo);
            this.request = request;
        }

        @Override
        protected String getHeaderValue(String headerName) {
            return this.request.getHeader(headerName);
        }

        @Override
        protected String getCookieValue(String cookieName) {
            Cookie[] cookies = this.request.getCookies();
            Cookie tokenCookie = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookieName.equals(cookie.getName())) continue;
                    tokenCookie = cookie;
                    break;
                }
            }
            if (tokenCookie != null) {
                return tokenCookie.getValue();
            }
            return null;
        }
    }
}

