/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.auth.principal.AbstractKeyLocationResolver;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.PrincipalLogging;
import java.security.Key;
import java.security.PrivateKey;
import java.util.List;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class DecryptionKeyLocationResolver
extends AbstractKeyLocationResolver
implements DecryptionKeyResolver {
    public DecryptionKeyLocationResolver(JWTAuthContextInfo authContextInfo) throws UnresolvableKeyException {
        super(authContextInfo);
        try {
            this.initializeKeyContent();
        }
        catch (Exception e) {
            DecryptionKeyLocationResolver.reportLoadKeyException(authContextInfo.getDecryptionKeyContent(), authContextInfo.getDecryptionKeyLocation(), e);
        }
    }

    public Key resolveKey(JsonWebEncryption jwe, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        DecryptionKeyLocationResolver.verifyKid((JsonWebStructure)jwe, this.authContextInfo.getTokenDecryptionKeyId());
        if (this.key != null) {
            return this.key;
        }
        Key theKey = this.tryAsDecryptionJwk(jwe);
        if (theKey == null) {
            DecryptionKeyLocationResolver.reportUnresolvableKeyException(this.authContextInfo.getDecryptionKeyContent(), this.authContextInfo.getDecryptionKeyLocation());
        }
        return theKey;
    }

    private Key tryAsDecryptionJwk(JsonWebEncryption jwe) throws UnresolvableKeyException {
        JsonWebKey jwk = super.tryAsJwk((JsonWebStructure)jwe, this.authContextInfo.getKeyEncryptionAlgorithm().getAlgorithm());
        if (jwk != null) {
            return ((PublicJsonWebKey)PublicJsonWebKey.class.cast(jwk)).getPrivateKey();
        }
        return null;
    }

    protected void initializeKeyContent() throws Exception {
        JsonWebKey jwk;
        String content;
        if (this.isHttpsJwksInitialized(this.authContextInfo.getDecryptionKeyLocation())) {
            return;
        }
        String string = content = this.authContextInfo.getDecryptionKeyContent() != null ? this.authContextInfo.getDecryptionKeyContent() : this.readKeyContent(this.authContextInfo.getDecryptionKeyLocation());
        if (this.mayBeFormat(KeyFormat.PEM_KEY)) {
            this.key = DecryptionKeyLocationResolver.tryAsPEMPrivateKey(content);
            if (this.key != null || this.isFormat(KeyFormat.PEM_KEY)) {
                return;
            }
        }
        if ((jwk = this.loadFromJwk(content, this.authContextInfo.getTokenDecryptionKeyId(), this.authContextInfo.getKeyEncryptionAlgorithm().getAlgorithm())) != null) {
            this.key = ((PublicJsonWebKey)PublicJsonWebKey.class.cast(jwk)).getPrivateKey();
        }
    }

    static PrivateKey tryAsPEMPrivateKey(String content) {
        PrincipalLogging.log.checkKeyContentIsBase64EncodedPEMKey();
        PrivateKey key = null;
        try {
            key = KeyUtils.decodeDecryptionPrivateKey(content);
            PrincipalLogging.log.keyCreatedFromEncodedPEMKey();
        }
        catch (Exception e) {
            PrincipalLogging.log.keyContentIsNotValidEncodedPEMKey(e);
        }
        return key;
    }
}

