/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.ResourceUtils;
import io.smallrye.jwt.build.impl.ImplMessages;
import java.io.IOException;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;

public class JwtBuildUtils {
    private JwtBuildUtils() {
    }

    static void setDefaultJwtClaims(JwtClaims claims) {
        String issuer;
        long currentTimeInSecs = JwtBuildUtils.currentTimeInSecs();
        if (!claims.hasClaim(Claims.iat.name())) {
            claims.setIssuedAt(NumericDate.fromSeconds((long)currentTimeInSecs));
        }
        JwtBuildUtils.setExpiryClaim(claims);
        if (!claims.hasClaim(Claims.jti.name())) {
            claims.setGeneratedJwtId();
        }
        if (!claims.hasClaim(Claims.iss.name()) && (issuer = JwtBuildUtils.getConfigProperty("smallrye.jwt.new-token.issuer", String.class)) != null) {
            claims.setIssuer(issuer);
        }
    }

    static <T> T getConfigProperty(String name, Class<T> cls) {
        return JwtBuildUtils.getConfigProperty(name, cls, null);
    }

    static <T> T getConfigProperty(String name, Class<T> cls, T defaultValue) {
        return ConfigProvider.getConfig().getOptionalValue(name, cls).orElse(defaultValue);
    }

    static String readJsonContent(String jsonResName) {
        try {
            String content = ResourceUtils.readResource(jsonResName);
            if (content == null) {
                throw ImplMessages.msg.failureToOpenInputStreamFromJsonResName(jsonResName);
            }
            return content;
        }
        catch (IOException ex) {
            throw ImplMessages.msg.failureToReadJsonContentFromJsonResName(jsonResName, ex.getMessage(), ex);
        }
    }

    static JwtClaims convertToClaims(Map<String, Object> claimsMap) {
        JwtClaims claims = new JwtClaims();
        JwtBuildUtils.convertToClaims(claims, claimsMap);
        return claims;
    }

    static void convertToClaims(JwtClaims claims, Map<String, Object> claimsMap) {
        for (Map.Entry<String, Object> entry : claimsMap.entrySet()) {
            claims.setClaim(entry.getKey(), entry.getValue());
        }
    }

    static int currentTimeInSecs() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    static void setExpiryClaim(JwtClaims claims) {
        if (!claims.hasClaim(Claims.exp.name())) {
            Long lifespan = JwtBuildUtils.getConfigProperty("smallrye.jwt.new-token.lifespan", Long.class, 300L);
            claims.setExpirationTime(NumericDate.fromSeconds((long)((long)JwtBuildUtils.currentTimeInSecs() + lifespan)));
        }
    }

    static JwtClaims parseJwtClaims(String jwtLocation) {
        try {
            return JwtClaims.parse((String)JwtBuildUtils.readJsonContent(jwtLocation));
        }
        catch (Exception ex) {
            throw ImplMessages.msg.failureToParseJWTClaims(ex.getMessage(), ex);
        }
    }
}

