package io.smallrye.jwt;

import java.util.Locale;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.lang.String;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class JWTMessages_$bundle implements JWTMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected JWTMessages_$bundle() {}
    public static final JWTMessages_$bundle INSTANCE = new JWTMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidJWKSPublicKey$str() {
        return "Failed to decode the JWKS Public Key";
    }
    @Override
    public final UncheckedIOException invalidJWKSPublicKey(final IOException ioe) {
        final UncheckedIOException result = new UncheckedIOException(String.format(getLoggingLocale(), invalidJWKSPublicKey$str()), ioe);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unsupportedAlgorithm$str() {
        return "SRJWT00001: Unsupported key type %s";
    }
    @Override
    public final NoSuchAlgorithmException unsupportedAlgorithm(final String algorithmName) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), unsupportedAlgorithm$str(), algorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyNotFound$str() {
        return "SRJWT00002: No resource with the named %s location exists";
    }
    @Override
    public final IOException keyNotFound(final String keyLocation) {
        final IOException result = new IOException(String.format(getLoggingLocale(), keyNotFound$str(), keyLocation));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
