/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.app;

import io.smallrye.metrics.app.Clock;
import io.smallrye.metrics.app.ExponentiallyDecayingReservoir;
import io.smallrye.metrics.app.HistogramImpl;
import io.smallrye.metrics.app.MeterImpl;
import io.smallrye.metrics.app.Reservoir;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

public class TimerImpl
implements Timer {
    private final MeterImpl meter;
    private final HistogramImpl histogram;
    private final Clock clock;

    public TimerImpl() {
        this(new ExponentiallyDecayingReservoir());
    }

    public TimerImpl(Reservoir reservoir) {
        this(reservoir, Clock.defaultClock());
    }

    public TimerImpl(Reservoir reservoir, Clock clock) {
        this.meter = new MeterImpl(clock);
        this.clock = clock;
        this.histogram = new HistogramImpl(reservoir);
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    public Context time() {
        return new Context(this, this.clock);
    }

    public long getCount() {
        return this.histogram.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.histogram.getSnapshot();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.update(duration);
            this.meter.mark();
        }
    }

    public Metered getMeter() {
        return this.meter;
    }

    public static class Context
    implements Timer.Context {
        private final TimerImpl timer;
        private final Clock clock;
        private final long startTime;

        private Context(TimerImpl timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(elapsed, TimeUnit.NANOSECONDS);
            return elapsed;
        }

        public void close() {
            this.stop();
        }
    }
}

