/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.extension;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionConstant;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class ExtensionReader {
    private ExtensionReader() {
    }

    public static Map<String, Object> readExtensions(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsMap("@Extension");
        LinkedHashMap<String, Object> e = new LinkedHashMap<String, Object>();
        for (AnnotationInstance annotation : nestedArray = annotationValue.asNestedArray()) {
            String extName = (String)Annotations.value(annotation, "name");
            e.put(extName, ExtensionReader.readExtensionValue(context, extName, annotation));
        }
        return e;
    }

    public static Map<String, Object> readExtensions(AnnotationScannerContext context, List<AnnotationInstance> extensions) {
        IoLogging.logger.annotationsMap("@Extension");
        LinkedHashMap<String, Object> e = new LinkedHashMap<String, Object>();
        for (AnnotationInstance annotation : extensions) {
            String extName = (String)Annotations.value(annotation, "name");
            e.put(extName, ExtensionReader.readExtensionValue(context, extName, annotation));
        }
        return e;
    }

    public static Map<String, Object> readExtensions(AnnotationScannerContext context, AnnotationInstance extensible) {
        List<Object> extensions;
        AnnotationInstance[] nestedExtensions = (AnnotationInstance[])Annotations.value(extensible, "extensions");
        if (nestedExtensions != null) {
            extensions = Arrays.asList(nestedExtensions);
        } else if (extensible.value("extensions") != null) {
            extensions = Collections.emptyList();
        } else {
            AnnotationTarget target = extensible.target();
            extensions = Annotations.getRepeatableAnnotation(target, ExtensionConstant.DOTNAME_EXTENSION, ExtensionConstant.DOTNAME_EXTENSIONS);
        }
        return extensions.isEmpty() ? null : ExtensionReader.readExtensions(context, extensions);
    }

    public static Object readExtensionValue(AnnotationScannerContext context, String name, AnnotationInstance annotationInstance) {
        Object parsedValue;
        block1: {
            AnnotationScannerExtension e;
            IoLogging.logger.annotation("@Extension");
            String extValue = (String)Annotations.value(annotationInstance, "value");
            boolean parseValue = Annotations.value(annotationInstance, "parseValue", Boolean.FALSE);
            parsedValue = extValue;
            if (!parseValue) break block1;
            Iterator<AnnotationScannerExtension> iterator = context.getExtensions().iterator();
            while (iterator.hasNext() && (parsedValue = (e = iterator.next()).parseExtension(name, extValue)) == null) {
            }
        }
        return parsedValue;
    }

    public static void readExtensions(JsonNode node, Extensible<?> model) {
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            if (!fieldName.toLowerCase().startsWith("x-")) continue;
            Object value = JsonUtil.readObject(node.get(fieldName));
            model.addExtension(fieldName, value);
        }
    }

    public static List<AnnotationInstance> getExtensionsAnnotations(AnnotationTarget target) {
        return Annotations.getRepeatableAnnotation(target, ExtensionConstant.DOTNAME_EXTENSION, ExtensionConstant.DOTNAME_EXTENSIONS);
    }

    public static String getExtensionName(AnnotationInstance annotation) {
        return (String)Annotations.value(annotation, "name");
    }
}

