/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.constants.JsonbConstants;
import io.smallrye.openapi.api.constants.KotlinSerializationConstants;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.IgnoreResolver;
import io.smallrye.openapi.runtime.scanner.dataobject.PropertyNamingStrategyFactory;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class TypeResolver {
    private static final Type BOOLEAN_TYPE = Type.create((DotName)DotName.createSimple((String)Boolean.class.getName()), (Type.Kind)Type.Kind.CLASS);
    static final String METHOD_PREFIX_GET = "get";
    static final String METHOD_PREFIX_IS = "is";
    static final String METHOD_PREFIX_SET = "set";
    static final Set<DotName> PROPERTY_METHOD_ANNOTATIONS = ModelUtil.supply(() -> {
        HashSet<DotName> value = new HashSet<DotName>();
        value.add(SchemaConstant.DOTNAME_SCHEMA);
        value.addAll(JsonbConstants.JSONB_PROPERTY);
        value.add(JacksonConstants.JSON_PROPERTY);
        return value;
    });
    private final AnnotationScannerContext context;
    private final UnaryOperator<String> nameTranslator;
    private final Deque<Map<String, Type>> resolutionStack;
    private final String propertyName;
    private FieldInfo field;
    private MethodInfo readMethod;
    private MethodInfo writeMethod;
    private boolean ignored = false;
    private boolean exposed = false;
    private boolean readOnly = false;
    private boolean writeOnly = false;
    private Type leaf;
    private final List<AnnotationTarget> constraintTargets = new ArrayList<AnnotationTarget>();
    private String propertyNamePrefix;
    private String propertyNameSuffix;
    private Comparator<AnnotationTarget> targetComparator;
    private static Function<AnnotationScannerContext, Comparator<AnnotationTarget>> comparatorFactory = ctxt -> (t1, t2) -> {
        int result = TypeResolver.compareAnnotation(ctxt, t1, t2, SchemaConstant.DOTNAME_SCHEMA);
        if (result != 0) {
            return result;
        }
        for (DotName jsonbProperty : JsonbConstants.JSONB_PROPERTY) {
            result = TypeResolver.compareAnnotation(ctxt, t1, t2, jsonbProperty);
            if (result == 0) continue;
            return result;
        }
        result = TypeResolver.compareAnnotation(ctxt, t1, t2, JacksonConstants.JSON_PROPERTY);
        if (result != 0) {
            return result;
        }
        for (DotName xmlElement : JaxbConstants.XML_ELEMENT) {
            result = TypeResolver.compareAnnotation(ctxt, t1, t2, xmlElement);
            if (result == 0) continue;
            return result;
        }
        for (DotName xmlAttribute : JaxbConstants.XML_ATTRIBUTE) {
            result = TypeResolver.compareAnnotation(ctxt, t1, t2, xmlAttribute);
            if (result == 0) continue;
            return result;
        }
        if (t1.kind() == AnnotationTarget.Kind.FIELD) {
            return -1;
        }
        if (t2.kind() == AnnotationTarget.Kind.FIELD) {
            return 1;
        }
        if (TypeResolver.isAccessor(ctxt, t1.asMethod()) && !TypeResolver.isAccessor(ctxt, t2.asMethod())) {
            return -1;
        }
        return 0;
    };
    private final Queue<AnnotationTarget> targets;

    private static int compareAnnotation(AnnotationScannerContext context, AnnotationTarget t1, AnnotationTarget t2, DotName annotationName) {
        boolean hasAnno1 = context.annotations().hasAnnotation(t1, annotationName);
        boolean hasAnno2 = context.annotations().hasAnnotation(t2, annotationName);
        if (hasAnno1) {
            if (!hasAnno2) {
                return -1;
            }
        } else if (hasAnno2) {
            return 1;
        }
        return 0;
    }

    public static Type resolve(Type type, TypeResolver resolver) {
        if (resolver != null) {
            return resolver.resolve(type);
        }
        return type;
    }

    private TypeResolver(AnnotationScannerContext context, UnaryOperator<String> nameTranslator, String propertyName, FieldInfo field, Deque<Map<String, Type>> resolutionStack) {
        this.context = context;
        this.nameTranslator = nameTranslator;
        this.propertyName = propertyName;
        this.field = field;
        this.resolutionStack = resolutionStack;
        this.targetComparator = comparatorFactory.apply(context);
        this.targets = new PriorityQueue<AnnotationTarget>(this.targetComparator);
        if (field != null) {
            this.leaf = field.type();
            this.targets.add((AnnotationTarget)field);
        } else {
            this.leaf = null;
        }
    }

    private void replaceResolutionStack(Deque<Map<String, Type>> replacementStack) {
        this.resolutionStack.clear();
        this.resolutionStack.addAll(replacementStack);
    }

    public ClassInfo getDeclaringClass() {
        return TypeUtil.getDeclaringClass(this.getAnnotationTarget());
    }

    public AnnotationTarget getAnnotationTarget() {
        return this.targets.peek();
    }

    public Type getUnresolvedType() {
        return this.leaf;
    }

    public String getPropertyName() {
        AnnotationTarget target = this.getAnnotationTarget();
        String name = (String)this.context.annotations().getAnnotationValue(target, SchemaConstant.DOTNAME_SCHEMA, "name");
        if (name != null) {
            return this.wrap(name);
        }
        name = (String)this.context.annotations().getAnnotationValue(target, JsonbConstants.JSONB_PROPERTY, "value");
        if (name != null) {
            return this.wrap(name);
        }
        name = (String)this.context.annotations().getAnnotationValue(target, JacksonConstants.JSON_PROPERTY, "value");
        if (name != null) {
            return this.wrap(name);
        }
        name = (String)this.context.annotations().getAnnotationValue(target, KotlinSerializationConstants.SERIAL_NAME, "value");
        if (name != null) {
            return this.wrap(name);
        }
        return (String)this.nameTranslator.apply(this.wrap(this.propertyName));
    }

    private String wrap(String name) {
        if (this.propertyNamePrefix == null && this.propertyNameSuffix == null) {
            return name;
        }
        StringBuilder wrapped = new StringBuilder();
        if (this.propertyNamePrefix != null) {
            wrapped.append(this.propertyNamePrefix);
        }
        wrapped.append(name);
        if (this.propertyNameSuffix != null) {
            wrapped.append(this.propertyNameSuffix);
        }
        return wrapped.toString();
    }

    public String getBeanPropertyName() {
        return this.propertyName;
    }

    public FieldInfo getField() {
        return this.field;
    }

    private void setField(FieldInfo field) {
        this.field = field;
        this.targets.add((AnnotationTarget)field);
    }

    public MethodInfo getReadMethod() {
        return this.readMethod;
    }

    private void setReadMethod(MethodInfo readMethod) {
        if (this.readMethod != null) {
            this.targets.remove(this.readMethod);
        }
        this.readMethod = readMethod;
        if (readMethod != null) {
            this.leaf = readMethod.returnType();
            this.targets.add((AnnotationTarget)readMethod);
        }
    }

    public MethodInfo getWriteMethod() {
        return this.writeMethod;
    }

    private void setWriteMethod(MethodInfo writeMethod) {
        if (this.writeMethod != null) {
            this.targets.remove(this.writeMethod);
        }
        this.writeMethod = writeMethod;
        if (writeMethod != null) {
            this.leaf = writeMethod.parameterType(0);
            this.targets.add((AnnotationTarget)writeMethod);
        }
    }

    public Type resolveType() {
        return TypeResolver.resolveType(this.leaf, this.resolutionStack);
    }

    public boolean isIgnored() {
        return this.ignored || this.readOnly && this.readMethod == null && this.field == null || this.writeOnly && this.writeMethod == null && this.field == null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isWriteOnly() {
        return this.writeOnly;
    }

    private boolean isExposedByDefault() {
        return !this.isIgnored() && !this.exposed;
    }

    private static Type resolveType(Type type, Deque<Map<String, Type>> resolutionStack) {
        return TypeResolver.resolveType(type, resolutionStack, true);
    }

    private static Type resolveType(Type type, Deque<Map<String, Type>> resolutionStack, boolean resolveWildcards) {
        if (type == null) {
            return null;
        }
        if (resolveWildcards) {
            type = TypeUtil.resolveWildcard(type);
        }
        Iterator<Map<String, Type>> iter = resolutionStack.iterator();
        while (iter.hasNext()) {
            String varName = null;
            switch (type.kind()) {
                case TYPE_VARIABLE: {
                    varName = type.asTypeVariable().identifier();
                    break;
                }
                case UNRESOLVED_TYPE_VARIABLE: {
                    varName = type.asUnresolvedTypeVariable().identifier();
                    break;
                }
            }
            if (varName != null) {
                Map<String, Type> varTypes = iter.next();
                if (!varTypes.containsKey(varName)) continue;
                type = varTypes.get(varName);
                continue;
            }
            if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                ArrayDeque<Map<String, Type>> resolvableTypes = new ArrayDeque<Map<String, Type>>();
                iter.forEachRemaining(resolvableTypes::addLast);
                type = TypeResolver.resolveType(type.asParameterizedType(), resolvableTypes);
                continue;
            }
            iter.next();
        }
        return type;
    }

    private static ParameterizedType resolveType(ParameterizedType type, Deque<Map<String, Type>> resolutionStack) {
        ParameterizedType.Builder builder = ParameterizedType.builder((DotName)type.name());
        Type owner = type.owner();
        if (owner != null) {
            builder.setOwner(TypeResolver.resolveType(owner, resolutionStack));
        }
        for (AnnotationInstance anno : type.annotations()) {
            builder.addAnnotation(anno);
        }
        for (Type arg : TypeResolver.resolveArguments(type, argType -> TypeResolver.resolveType(argType, resolutionStack, false))) {
            builder.addArgument(arg);
        }
        return builder.build();
    }

    private static Type[] resolveArguments(ParameterizedType type, UnaryOperator<Type> resolver) {
        return (Type[])type.arguments().stream().map(resolver).toArray(Type[]::new);
    }

    public Type resolve(Type type) {
        return TypeResolver.resolveType(type, this.resolutionStack);
    }

    public List<AnnotationTarget> getConstraintTargets() {
        return this.constraintTargets;
    }

    public static TypeResolver forClass(AnnotationScannerContext context, ClassInfo clazz, Type leaf) {
        AugmentedIndexView index = context.getAugmentedIndex();
        Type clazzType = leaf != null ? leaf : Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS);
        Map<ClassInfo, Type> chain = index.inheritanceChain(clazz, clazzType);
        ArrayDeque<Map<String, Type>> stack = new ArrayDeque<Map<String, Type>>();
        boolean allOfMatch = false;
        for (Map.Entry<ClassInfo, Type> entry : chain.entrySet()) {
            ClassInfo currentClass = entry.getKey();
            Type currentType = entry.getValue();
            if (currentType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                stack.push(TypeResolver.buildParamTypeResolutionMap(currentClass, currentType));
            }
            index.interfaces(currentClass).stream().filter(type -> type.kind() == Type.Kind.PARAMETERIZED_TYPE).filter(index::containsClass).map(type -> TypeResolver.buildParamTypeResolutionMap(index.getClass((Type)type), type)).forEach(stack::push);
            if (!allOfMatch && (currentType.equals((Object)clazzType) || !TypeUtil.isIncludedAllOf(context, clazz, currentType))) continue;
            allOfMatch = true;
        }
        return new TypeResolver(context, TypeResolver.getPropertyNameTranslator(context, (AnnotationTarget)clazz), null, null, stack);
    }

    public static Map<String, TypeResolver> getAllFields(AnnotationScannerContext context, Type leaf, ClassInfo leafKlazz, AnnotationTarget reference) {
        AugmentedIndexView index = context.getAugmentedIndex();
        Map<ClassInfo, Type> chain = index.inheritanceChain(leafKlazz, leaf);
        LinkedHashMap<String, TypeResolver> properties = new LinkedHashMap<String, TypeResolver>();
        ArrayDeque<Map<String, Type>> stack = new ArrayDeque<Map<String, Type>>();
        boolean skipPropertyScan = false;
        ArrayList<ClassInfo> descendants = new ArrayList<ClassInfo>(chain.size());
        for (Map.Entry<ClassInfo, Type> entry : chain.entrySet()) {
            ClassInfo currentClass = entry.getKey();
            Type currentType = entry.getValue();
            TypeResolver.maybeAddResolutionParams(stack, currentType, currentClass);
            if (skipPropertyScan || !currentType.equals((Object)leaf) && TypeUtil.isAllOf(context, leafKlazz, currentType) || TypeUtil.knownJavaType(currentClass.name())) {
                skipPropertyScan = true;
                continue;
            }
            JandexUtil.fields(context, currentClass).stream().filter(TypeResolver::acceptField).filter(field -> field.name().chars().allMatch(Character::isJavaIdentifierPart)).forEach(field -> TypeResolver.scanField(context, properties, field, stack, reference, descendants));
            TypeResolver.methods(context, currentClass).stream().filter(TypeResolver::acceptMethod).filter(method -> method.name().chars().allMatch(Character::isJavaIdentifierPart)).forEach(method -> TypeResolver.scanMethod(context, properties, method, stack, reference, descendants));
            index.interfaces(currentClass).stream().filter(type -> !TypeUtil.knownJavaType(type.name())).map(type -> {
                ClassInfo clazz = index.getClass((Type)type);
                TypeResolver.maybeAddResolutionParams(stack, type, clazz);
                return clazz;
            }).filter(Objects::nonNull).flatMap(clazz -> TypeResolver.methods(context, clazz).stream()).filter(method -> method.name().chars().allMatch(Character::isJavaIdentifierPart)).forEach(method -> TypeResolver.scanMethod(context, properties, method, stack, reference, descendants));
            descendants.add(currentClass);
        }
        if (!context.getConfig().privatePropertiesEnable()) {
            properties.values().stream().filter(TypeResolver::isExposedByDefault).filter(resolver -> TypeResolver.isNonPublicOrAbsent(resolver.field)).filter(resolver -> TypeResolver.isNonPublicOrAbsent(resolver.readMethod)).filter(resolver -> TypeResolver.isNonPublicOrAbsent(resolver.writeMethod)).forEach(property -> {
                property.ignored = true;
            });
        }
        return TypeResolver.sorted(context, properties, chain.keySet());
    }

    private static void maybeAddResolutionParams(Deque<Map<String, Type>> stack, Type type, ClassInfo clazz) {
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && clazz != null) {
            stack.push(TypeResolver.buildParamTypeResolutionMap(clazz, type));
        }
    }

    private static List<MethodInfo> methods(AnnotationScannerContext context, ClassInfo currentClass) {
        if (context.getConfig().sortedPropertiesEnable()) {
            return currentClass.methods();
        }
        return currentClass.methodsInDeclarationOrder();
    }

    private static boolean acceptMethod(MethodInfo method) {
        if (Modifier.isStatic(method.flags()) || method.isSynthetic()) {
            return false;
        }
        String name = method.name();
        return !name.equals("<init>") && !name.equals("getClass");
    }

    private static boolean acceptField(FieldInfo field) {
        return !Modifier.isStatic(field.flags()) && !field.isSynthetic();
    }

    private static boolean isNonPublicOrAbsent(FieldInfo field) {
        return field == null || !Modifier.isPublic(field.flags());
    }

    private static boolean isNonPublicOrAbsent(MethodInfo method) {
        return method == null || !Modifier.isPublic(method.flags());
    }

    private void processVisibility(AnnotationScannerContext context, AnnotationTarget target, AnnotationTarget reference, List<ClassInfo> descendants) {
        if (this.exposed || this.ignored) {
            return;
        }
        switch (this.getVisibility(context, target, reference, descendants, this.propertyName)) {
            case EXPOSED: {
                this.exposed = true;
                break;
            }
            case IGNORED: {
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    if (TypeResolver.isAccessor(context, target.asMethod())) {
                        this.writeOnly = true;
                    } else {
                        this.readOnly = true;
                    }
                    if (!this.readOnly || !this.writeOnly) break;
                    this.ignored = true;
                    break;
                }
                this.ignored = true;
                break;
            }
        }
    }

    private void processAccess(AnnotationTarget target) {
        if (this.ignored) {
            return;
        }
        switch (this.context.annotations().getAnnotationValue(target, Collections.singletonList(JacksonConstants.JSON_PROPERTY), "access", "AUTO")) {
            case "READ_ONLY": {
                this.readOnly = true;
                break;
            }
            case "WRITE_ONLY": {
                this.writeOnly = true;
                break;
            }
            case "READ_WRITE": {
                this.readOnly = false;
                this.writeOnly = false;
                break;
            }
        }
    }

    private IgnoreResolver.Visibility getVisibility(AnnotationScannerContext context, AnnotationTarget target, AnnotationTarget reference, List<ClassInfo> descendants, String propertyName) {
        if (!TypeResolver.isViewable(context, target)) {
            return IgnoreResolver.Visibility.IGNORED;
        }
        IgnoreResolver ignoreResolver = context.getIgnoreResolver();
        IgnoreResolver.Visibility visibility = ignoreResolver.referenceVisibility(propertyName, target, reference);
        if (visibility != IgnoreResolver.Visibility.UNSET) {
            return visibility;
        }
        if (this.isUnhidden(target)) {
            return IgnoreResolver.Visibility.EXPOSED;
        }
        visibility = ignoreResolver.getDescendantVisibility(propertyName, descendants);
        if (visibility == IgnoreResolver.Visibility.UNSET) {
            visibility = ignoreResolver.isIgnore(propertyName, target, reference);
        }
        return visibility;
    }

    private static boolean isViewable(AnnotationScannerContext context, AnnotationTarget propertySource) {
        Map<Type, Boolean> activeViews = context.getJsonViews();
        if (activeViews.isEmpty()) {
            return true;
        }
        Type[] applicableViews = TypeResolver.getJsonViews(context, propertySource);
        if (applicableViews != null && applicableViews.length > 0) {
            return Arrays.stream(applicableViews).anyMatch(activeViews::containsKey);
        }
        return true;
    }

    private static Type[] getJsonViews(AnnotationScannerContext context, AnnotationTarget propertySource) {
        Annotations annotations = context.annotations();
        AnnotationInstance jsonView = annotations.getAnnotation(propertySource, JacksonConstants.JSON_VIEW);
        if (jsonView != null) {
            return (Type[])annotations.value(jsonView);
        }
        ClassInfo declaringClass = propertySource.kind() == AnnotationTarget.Kind.FIELD ? propertySource.asField().declaringClass() : propertySource.asMethod().declaringClass();
        return (Type[])annotations.getAnnotationValue((AnnotationTarget)declaringClass, JacksonConstants.JSON_VIEW);
    }

    boolean isUnhidden(AnnotationTarget target) {
        Boolean hidden;
        Annotations annotations;
        AnnotationInstance schema;
        return target != null && (schema = (annotations = this.context.annotations()).getAnnotation(target, SchemaConstant.DOTNAME_SCHEMA)) != null && ((hidden = (Boolean)annotations.value(schema, "hidden")) == null || hidden == false);
    }

    private static void scanField(AnnotationScannerContext context, Map<String, TypeResolver> properties, FieldInfo field, Deque<Map<String, Type>> stack, AnnotationTarget reference, List<ClassInfo> descendants) {
        TypeResolver resolver;
        boolean unwrapped;
        String propertyName = field.name();
        Type fieldType = TypeResolver.resolveType(field.type(), stack);
        ClassInfo fieldClass = context.getAugmentedIndex().getClass(fieldType);
        if (field.hasAnnotation(JacksonConstants.JSON_UNWRAPPED) && fieldClass != null) {
            unwrapped = true;
            properties.putAll(TypeResolver.unwrapProperties(context, (AnnotationTarget)field, fieldType, fieldClass));
        } else {
            unwrapped = false;
        }
        if (properties.containsKey(propertyName)) {
            resolver = properties.get(propertyName);
            if (resolver.getField() == null && (Modifier.isPublic(field.flags()) || Modifier.isProtected(field.flags()) || context.getConfig().privatePropertiesEnable())) {
                resolver.setField(field);
            }
        } else {
            resolver = new TypeResolver(context, TypeResolver.getPropertyNameTranslator(context, (AnnotationTarget)field), propertyName, field, new ArrayDeque<Map<String, Type>>(stack));
            properties.put(propertyName, resolver);
        }
        if (context.getBeanValidationScanner().map(s -> s.hasConstraints((AnnotationTarget)field)).orElse(false).booleanValue()) {
            resolver.constraintTargets.add((AnnotationTarget)field);
        }
        if (unwrapped) {
            resolver.ignored = true;
        } else {
            resolver.processVisibility(context, (AnnotationTarget)field, reference, descendants);
            resolver.processAccess((AnnotationTarget)field);
        }
    }

    private static Map<String, TypeResolver> unwrapProperties(AnnotationScannerContext context, AnnotationTarget member, Type memberType, ClassInfo memberClass) {
        Map<String, TypeResolver> unwrappedProperties = TypeResolver.getAllFields(context, memberType, memberClass, member);
        AnnotationInstance jsonUnwrapped = context.annotations().getAnnotation(member, JacksonConstants.JSON_UNWRAPPED);
        String unwrapPrefix = (String)context.annotations().value(jsonUnwrapped, "prefix");
        String unwrapSuffix = (String)context.annotations().value(jsonUnwrapped, "suffix");
        return unwrappedProperties.entrySet().stream().map(p -> TypeResolver.applyPrefixSuffix(p, unwrapPrefix, unwrapSuffix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static Map.Entry<String, TypeResolver> applyPrefixSuffix(Map.Entry<String, TypeResolver> property, String prefix, String suffix) {
        TypeResolver unwrappedResolver = property.getValue();
        StringBuilder key = new StringBuilder();
        if (prefix != null) {
            unwrappedResolver.propertyNamePrefix = prefix;
            key.append(prefix);
        }
        key.append(property.getKey());
        if (suffix != null) {
            unwrappedResolver.propertyNameSuffix = suffix;
            key.append(suffix);
        }
        return new AbstractMap.SimpleEntry<String, TypeResolver>(key.toString(), unwrappedResolver);
    }

    private static void scanMethod(AnnotationScannerContext context, Map<String, TypeResolver> properties, MethodInfo method, Deque<Map<String, Type>> stack, AnnotationTarget reference, List<ClassInfo> descendants) {
        TypeResolver resolver;
        Type returnType = TypeResolver.resolveType(method.returnType(), stack);
        Type propertyType = null;
        if (TypeResolver.isAccessor(context, method)) {
            propertyType = returnType;
        } else if (TypeResolver.isMutator(context, method)) {
            propertyType = method.parameterType(0);
        }
        if (propertyType != null && (resolver = TypeResolver.updateTypeResolvers(context, properties, stack, method, propertyType)) != null) {
            resolver.processVisibility(context, (AnnotationTarget)method, reference, descendants);
            resolver.processAccess((AnnotationTarget)method);
        }
    }

    private static TypeResolver updateTypeResolvers(AnnotationScannerContext context, Map<String, TypeResolver> properties, Deque<Map<String, Type>> stack, MethodInfo method, Type propertyType) {
        TypeResolver resolver;
        String propertyName = TypeResolver.propertyName(properties, method);
        if (propertyName == null) {
            return null;
        }
        if (properties.containsKey(propertyName)) {
            resolver = properties.get(propertyName);
            Type resolvedPropertyType = TypeResolver.resolveType(propertyType, stack);
            if (!TypeUtil.equalTypes(resolver.resolveType(), resolvedPropertyType)) {
                return resolver;
            }
        } else {
            resolver = new TypeResolver(context, TypeResolver.getPropertyNameTranslator(context, (AnnotationTarget)method), propertyName, null, new ArrayDeque<Map<String, Type>>(stack));
            properties.put(propertyName, resolver);
        }
        boolean isWriteMethod = TypeResolver.isMutator(context, method);
        if (isWriteMethod) {
            if (TypeResolver.isHigherPriority(resolver.targetComparator, method, resolver.getWriteMethod())) {
                resolver.setWriteMethod(method);
                resolver.replaceResolutionStack(stack);
            }
        } else if (TypeResolver.isHigherPriority(resolver.targetComparator, method, resolver.getReadMethod())) {
            resolver.setReadMethod(method);
            resolver.replaceResolutionStack(stack);
        }
        if (context.getBeanValidationScanner().map(s -> s.hasConstraints((AnnotationTarget)method)).orElse(false).booleanValue()) {
            resolver.constraintTargets.add((AnnotationTarget)method);
        }
        return resolver;
    }

    static String propertyName(Map<String, TypeResolver> properties, MethodInfo method) {
        String propertyName;
        String methodName = method.name();
        ClassInfo declaringClass = method.declaringClass();
        if (declaringClass.isRecord() && declaringClass.recordComponent(methodName) != null) {
            return methodName;
        }
        if (Optional.ofNullable(properties.get(methodName)).map(p -> p.field).isPresent()) {
            return methodName;
        }
        int nameStart = TypeResolver.methodNamePrefix(method).length();
        if (methodName.length() == nameStart) {
            return null;
        }
        if (nameStart > 0) {
            StringBuilder nameBuffer = new StringBuilder(methodName.length());
            nameBuffer.append(methodName);
            nameBuffer.setCharAt(nameStart, Character.toLowerCase(methodName.charAt(nameStart)));
            propertyName = nameBuffer.substring(nameStart);
        } else {
            propertyName = methodName;
        }
        return propertyName;
    }

    private static boolean isAccessor(AnnotationScannerContext context, MethodInfo method) {
        if (!JandexUtil.isSupplier((AnnotationTarget)method)) {
            return false;
        }
        ClassInfo clazz = method.declaringClass();
        if (clazz.isRecord() && clazz.recordComponent(method.name()) != null) {
            return true;
        }
        String namePrefix = TypeResolver.methodNamePrefix(method);
        if (METHOD_PREFIX_GET.equals(namePrefix)) {
            return true;
        }
        if (METHOD_PREFIX_IS.equals(namePrefix) && TypeUtil.equalTypes(method.returnType(), BOOLEAN_TYPE)) {
            return true;
        }
        return TypeResolver.isAnnotatedProperty(context, method);
    }

    private static boolean isMutator(AnnotationScannerContext context, MethodInfo method) {
        if (method.parametersCount() != 1) {
            return false;
        }
        if (TypeResolver.isAnnotatedProperty(context, method)) {
            return true;
        }
        return Type.Kind.VOID.equals((Object)method.returnType().kind()) && METHOD_PREFIX_SET.equals(TypeResolver.methodNamePrefix(method));
    }

    static boolean isAnnotatedProperty(AnnotationScannerContext context, MethodInfo method) {
        return context.annotations().hasAnnotation((AnnotationTarget)method, PROPERTY_METHOD_ANNOTATIONS);
    }

    private static String methodNamePrefix(MethodInfo method) {
        String methodName = method.name();
        if (methodName.startsWith(METHOD_PREFIX_GET)) {
            return METHOD_PREFIX_GET;
        }
        if (methodName.startsWith(METHOD_PREFIX_IS)) {
            return METHOD_PREFIX_IS;
        }
        if (methodName.startsWith(METHOD_PREFIX_SET)) {
            return METHOD_PREFIX_SET;
        }
        return "";
    }

    private static boolean isHigherPriority(Comparator<AnnotationTarget> targetComparator, MethodInfo newMethod, MethodInfo oldMethod) {
        if (oldMethod == null) {
            return true;
        }
        if (Modifier.isInterface(newMethod.declaringClass().flags())) {
            return targetComparator.compare((AnnotationTarget)newMethod, (AnnotationTarget)oldMethod) < 0;
        }
        return false;
    }

    private static UnaryOperator<String> getPropertyNameTranslator(AnnotationScannerContext context, AnnotationTarget target) {
        Type namingClass;
        ClassInfo clazz = target.kind() == AnnotationTarget.Kind.CLASS ? target.asClass() : TypeUtil.getDeclaringClass(target);
        AnnotationInstance jacksonNaming = context.annotations().getAnnotation((AnnotationTarget)clazz, JacksonConstants.JSON_NAMING);
        UnaryOperator<String> translator = jacksonNaming != null ? ((namingClass = (Type)context.annotations().value(jacksonNaming, "value")) != null ? PropertyNamingStrategyFactory.getStrategy(namingClass.name().toString(), context.getClassLoader()) : PropertyNamingStrategyFactory.getStrategy("IDENTITY", context.getClassLoader())) : context.getPropertyNameTranslator();
        return translator;
    }

    private static Map<String, TypeResolver> sorted(AnnotationScannerContext context, Map<String, TypeResolver> properties, Set<ClassInfo> chainKeys) {
        ArrayList<ClassInfo> chain = new ArrayList<ClassInfo>(chainKeys);
        Collections.reverse(chain);
        List order = chain.stream().map(clazz -> TypeResolver.propertyOrder(context, clazz)).flatMap(Collection::stream).collect(Collectors.toList());
        List chainClassNames = chain.stream().map(ClassInfo::name).collect(Collectors.toList());
        return properties.entrySet().stream().sorted((e1, e2) -> {
            int pIndex2;
            TypeResolver r1 = (TypeResolver)e1.getValue();
            TypeResolver r2 = (TypeResolver)e2.getValue();
            ClassInfo c1 = r1.getDeclaringClass();
            ClassInfo c2 = r2.getDeclaringClass();
            int pIndex1 = order.indexOf(r1.getPropertyName());
            if (pIndex1 < 0) {
                pIndex1 = order.indexOf(e1.getKey());
            }
            if ((pIndex2 = order.indexOf(r2.getPropertyName())) < 0) {
                pIndex2 = order.indexOf(e2.getKey());
            }
            if (pIndex1 > -1) {
                if (pIndex2 < 0) {
                    return -1;
                }
                return Integer.compare(pIndex1, pIndex2);
            }
            if (pIndex2 > -1) {
                return 1;
            }
            int cIndex1 = chainClassNames.indexOf(c1.name());
            int cIndex2 = chainClassNames.indexOf(c2.name());
            return Integer.compare(cIndex1, cIndex2);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static List<String> propertyOrder(AnnotationScannerContext context, ClassInfo clazz) {
        AnnotationValue orderArray = null;
        AnnotationInstance propertyOrder = context.annotations().getAnnotation((AnnotationTarget)clazz, JsonbConstants.JSONB_PROPERTY_ORDER);
        if (propertyOrder != null) {
            orderArray = propertyOrder.value();
        } else {
            propertyOrder = context.annotations().getAnnotation((AnnotationTarget)clazz, JaxbConstants.XML_TYPE);
            if (propertyOrder != null) {
                orderArray = propertyOrder.value("propOrder");
            } else {
                propertyOrder = context.annotations().getAnnotation((AnnotationTarget)clazz, JacksonConstants.JSON_PROPERTY_ORDER);
                if (propertyOrder != null) {
                    orderArray = propertyOrder.value();
                }
            }
        }
        if (orderArray != null) {
            return Arrays.asList(orderArray.asStringArray());
        }
        return Collections.emptyList();
    }

    private static Map<String, Type> buildParamTypeResolutionMap(ClassInfo klazz, ParameterizedType parameterizedType) {
        List typeVariables = klazz.typeParameters();
        List arguments = parameterizedType.arguments();
        if (arguments.size() != typeVariables.size()) {
            String vars = typeVariables.stream().map(Type::toString).collect(Collectors.joining(", "));
            DataObjectLogging.logger.classNotAvailable(String.valueOf(klazz.name()) + "<" + vars + ">", parameterizedType.toString());
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Type> resolutionMap = new LinkedHashMap<String, Type>();
        for (int i = 0; i < arguments.size(); ++i) {
            TypeVariable typeVar = (TypeVariable)typeVariables.get(i);
            Type arg = (Type)arguments.get(i);
            resolutionMap.put(typeVar.identifier(), arg);
        }
        return resolutionMap;
    }

    private static Map<String, Type> buildParamTypeResolutionMap(ClassInfo klazz, Type type) {
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return TypeResolver.buildParamTypeResolutionMap(klazz, type.asParameterizedType());
        }
        return Collections.emptyMap();
    }

    public static Optional<ParameterizedType> resolveParameterizedAncestor(AnnotationScannerContext context, Type type, Type seekType) {
        ClassInfo cursorClass;
        CompositeIndex index = CompositeIndex.create((IndexView[])new IndexView[]{context.getAugmentedIndex(), TypeUtil.jdkIndex});
        Type cursor = type;
        boolean seekContinue = true;
        while ((cursorClass = index.getClassByName(cursor.name())) != null && seekContinue) {
            Map<String, Type> resolutionMap = TypeResolver.buildParamTypeResolutionMap(cursorClass, cursor);
            List<Type> interfaces = TypeResolver.getInterfacesOfType(context, cursorClass, seekType);
            for (Type implementedType : interfaces) {
                cursor = TypeResolver.createParameterizedType(implementedType, resolutionMap);
                if (!implementedType.name().equals((Object)seekType.name())) continue;
                seekContinue = false;
                break;
            }
            if (!interfaces.isEmpty()) continue;
            Type superType = cursorClass.superClassType();
            if (TypeUtil.isA(context, superType, seekType)) {
                cursor = TypeResolver.createParameterizedType(superType, resolutionMap);
                continue;
            }
            seekContinue = false;
        }
        return cursor.kind() == Type.Kind.PARAMETERIZED_TYPE ? Optional.of(cursor.asParameterizedType()) : Optional.empty();
    }

    private static List<Type> getInterfacesOfType(AnnotationScannerContext context, ClassInfo clazz, Type seekType) {
        return clazz.interfaceTypes().stream().filter(t -> TypeUtil.isA(context, t, seekType)).collect(Collectors.toList());
    }

    private static ParameterizedType createParameterizedType(Type targetType, Map<String, Type> resolutionMap) {
        if (targetType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return ParameterizedType.create((DotName)targetType.name(), (Type[])Type.EMPTY_ARRAY, null);
        }
        Type[] resolvedArgs = TypeResolver.resolveArguments(targetType.asParameterizedType(), t -> TypeResolver.resolveType(t, resolutionMap));
        return ParameterizedType.create((DotName)targetType.name(), (Type[])resolvedArgs, null);
    }

    private static Type resolveType(Type type, Map<String, Type> resolutionMap) {
        switch (type.kind()) {
            case PARAMETERIZED_TYPE: {
                return TypeResolver.createParameterizedType(type, resolutionMap);
            }
            case TYPE_VARIABLE: {
                String id = type.asTypeVariable().identifier();
                return resolutionMap.getOrDefault(id, type);
            }
        }
        return type;
    }
}

