/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.vertx;

import io.smallrye.openapi.runtime.io.parameter.ParameterConstant;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.spi.AbstractParameterProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.FrameworkParameter;
import io.smallrye.openapi.runtime.util.TypeUtil;
import io.smallrye.openapi.vertx.VertxConstants;
import io.smallrye.openapi.vertx.VertxParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class VertxParameterProcessor
extends AbstractParameterProcessor {
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile(":[ \\t]*(\\w[\\w\\.-]*)[ \\t]*:[ \\t]*((?:[^{}]|\\{[^{}]+\\})+)");

    private VertxParameterProcessor(AnnotationScannerContext scannerContext, String contextPath, Function<AnnotationInstance, Parameter> reader, List<AnnotationScannerExtension> extensions) {
        super(scannerContext, contextPath, reader, extensions);
    }

    public static ResourceParameters process(AnnotationScannerContext context, String contextPath, ClassInfo resourceClass, MethodInfo resourceMethod, Function<AnnotationInstance, Parameter> reader, List<AnnotationScannerExtension> extensions) {
        VertxParameterProcessor processor = new VertxParameterProcessor(context, contextPath, reader, extensions);
        return processor.process(resourceClass, resourceMethod);
    }

    protected Pattern getTemplateParameterPattern() {
        return TEMPLATE_PARAM_PATTERN;
    }

    protected FrameworkParameter getMatrixParameter() {
        return null;
    }

    protected void readAnnotatedType(AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        DotName name = annotation.name();
        if (this.isReadableParameterAnnotation(name)) {
            this.readParameterAnnotation(annotation, overriddenParametersOnly);
        } else if (VertxConstants.PARAM.equals((Object)name) && annotation.value() != null) {
            FrameworkParameter vertxParameter;
            String parameterName = annotation.value().asString();
            String path = null;
            MethodInfo resourceMethod = null;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                resourceMethod = annotation.target().asMethod();
            } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                resourceMethod = annotation.target().asMethodParameter().method();
            }
            if (resourceMethod != null) {
                AnnotationInstance routeAnnotation = resourceMethod.annotation(VertxConstants.ROUTE);
                AnnotationValue pathValue = routeAnnotation.value("path");
                path = resourceMethod.name();
                if (pathValue != null) {
                    path = pathValue.asString();
                }
            }
            if (path != null && path.contains(":" + parameterName)) {
                vertxParameter = VertxParameter.PATH_PARAM.parameter;
                this.readAnnotatedType(vertxParameter, annotation, beanParamAnnotation, overriddenParametersOnly);
            } else {
                vertxParameter = VertxParameter.QUERY_PARAM.parameter;
                this.readAnnotatedType(vertxParameter, annotation, beanParamAnnotation, overriddenParametersOnly);
            }
        } else if (VertxConstants.HEADER_PARAM.equals((Object)name) && annotation.value() != null) {
            FrameworkParameter vertxParameter = VertxParameter.HEADER_PARAM.parameter;
            this.readAnnotatedType(vertxParameter, annotation, beanParamAnnotation, overriddenParametersOnly);
        }
    }

    private void readAnnotatedType(FrameworkParameter frameworkParam, AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        if (frameworkParam != null) {
            AnnotationTarget target = annotation.target();
            Type targetType = VertxParameterProcessor.getType((AnnotationTarget)target);
            if (frameworkParam.style == Parameter.Style.FORM) {
                this.formParams.put(VertxParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
                this.readFrameworkParameter(annotation, frameworkParam, overriddenParametersOnly);
            } else if (frameworkParam.style == Parameter.Style.MATRIX) {
                String pathSegment = beanParamAnnotation != null ? this.lastPathSegmentOf(beanParamAnnotation.target()) : this.lastPathSegmentOf(target);
                this.matrixParams.computeIfAbsent(pathSegment, k -> new HashMap()).put(VertxParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
            } else if (frameworkParam.location != null) {
                this.readFrameworkParameter(annotation, frameworkParam, overriddenParametersOnly);
            } else if (target != null) {
                this.setMediaType(frameworkParam);
                targetType = TypeUtil.unwrapType((Type)targetType);
                if (targetType != null) {
                    ClassInfo beanParam = this.index.getClassByName(targetType.name());
                    this.readParameters(beanParam, annotation, overriddenParametersOnly);
                }
            }
        }
    }

    protected String pathOf(AnnotationTarget target) {
        String pathValue;
        DotName possiblePath;
        AnnotationInstance path = null;
        String defaultPathValue = null;
        if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
            possiblePath = VertxConstants.ROUTE_BASE;
            AnnotationInstance classAnnotation = this.scannerContext.annotations().getAnnotation(target, new DotName[]{possiblePath});
            if (classAnnotation != null && classAnnotation.value("path") != null) {
                path = classAnnotation;
            }
        } else if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
            defaultPathValue = target.asMethod().name();
            possiblePath = VertxConstants.ROUTE;
            AnnotationInstance methodAnnotation = target.asMethod().annotation(possiblePath);
            if (methodAnnotation != null) {
                path = methodAnnotation;
            }
        }
        if (path != null && (pathValue = VertxParameterProcessor.routePathValuesToPath(path, defaultPathValue)) != null) {
            if (pathValue.startsWith("/")) {
                pathValue = pathValue.substring(1);
            }
            if (pathValue.endsWith("/")) {
                pathValue = pathValue.substring(0, pathValue.length() - 1);
            }
            if (pathValue.contains(":")) {
                List<String> parts = Arrays.asList(pathValue.split("/"));
                ArrayList<String> partsConverted = new ArrayList<String>();
                for (String part : parts) {
                    if (part.startsWith(":")) {
                        part = "{" + part.substring(1) + "}";
                    }
                    partsConverted.add(part);
                }
                pathValue = String.join((CharSequence)"/", partsConverted.toArray(new String[0]));
            }
            return pathValue;
        }
        return "";
    }

    static String routePathValuesToPath(AnnotationInstance routeAnnotation, String defaultValue) {
        AnnotationValue value = routeAnnotation.value("path");
        if (value != null) {
            return value.asString();
        }
        return defaultValue;
    }

    protected boolean isSubResourceLocator(MethodInfo method) {
        return false;
    }

    protected boolean isResourceMethod(MethodInfo method) {
        return method.annotations().stream().map(AnnotationInstance::name).anyMatch(arg_0 -> ((DotName)VertxConstants.ROUTE).equals(arg_0));
    }

    protected boolean isParameter(DotName annotationName) {
        if (VertxParameter.isParameter(annotationName)) {
            return true;
        }
        if (ParameterConstant.DOTNAME_PARAMETER.equals((Object)annotationName)) {
            return true;
        }
        return ParameterConstant.DOTNAME_PARAMETERS.equals((Object)annotationName);
    }
}

