/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.servicediscovery.dns;

import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.servicediscovery.dns.DnsConfiguration;
import io.smallrye.stork.servicediscovery.dns.DnsServiceDiscoveryProvider;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class DnsServiceDiscoveryProviderLoader
implements ServiceDiscoveryLoader {
    private final DnsServiceDiscoveryProvider provider;

    public DnsServiceDiscoveryProviderLoader() {
        DnsServiceDiscoveryProvider actual = null;
        try {
            actual = (DnsServiceDiscoveryProvider)CDI.current().select(DnsServiceDiscoveryProvider.class, new Annotation[0]).get();
        }
        catch (Exception e) {
            actual = new DnsServiceDiscoveryProvider();
        }
        this.provider = actual;
    }

    public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName, ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {
        DnsConfiguration typedConfig = new DnsConfiguration(config.parameters());
        return this.provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);
    }

    public String type() {
        return "dns";
    }
}

