/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.snyk_maven_plugin.command;

import io.snyk.snyk_maven_plugin.command.Command;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface CommandLine {
    public static final String INTEGRATION_NAME = "MAVEN_PLUGIN";

    public Process start() throws IOException;

    public static ProcessBuilder asProcessBuilder(String cliExecutablePath, Command command, Optional<String> apiToken, List<String> args, boolean color) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(cliExecutablePath);
        Collections.addAll(parts, command.commandParameters());
        parts.add("--integration-name=MAVEN_PLUGIN");
        args.stream().map(String::trim).filter(arg -> !arg.isEmpty()).filter(arg -> !arg.startsWith("--integration-name")).forEach(parts::add);
        ProcessBuilder pb = new ProcessBuilder(parts);
        if (color) {
            pb.environment().put("FORCE_COLOR", "true");
        }
        apiToken.ifPresent(t -> pb.environment().put("SNYK_TOKEN", (String)t));
        return pb;
    }
}

