/*
 * Decompiled with CFR 0.152.
 */
package io.snyk.snyk_maven_plugin.goal;

import io.snyk.snyk_maven_plugin.command.Command;
import io.snyk.snyk_maven_plugin.command.CommandLine;
import io.snyk.snyk_maven_plugin.command.CommandRunner;
import io.snyk.snyk_maven_plugin.download.ExecutableDownloader;
import io.snyk.snyk_maven_plugin.download.FileDownloader;
import io.snyk.snyk_maven_plugin.goal.MojoExecutor;
import io.snyk.snyk_maven_plugin.goal.SnykMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class SnykMojoExecutor
implements MojoExecutor {
    private static final int EXIT_CODE_OK = 0;
    private static final int EXIT_CODE_ACTION_NEEDED = 1;
    private final SnykMojo mojo;

    public SnykMojoExecutor(SnykMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.mojo.shouldSkip()) {
            this.mojo.getLog().info((CharSequence)("snyk " + this.mojo.getCommand().commandName() + " skipped"));
            return;
        }
        int exitCode = this.executeCommand();
        switch (exitCode) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.mojo.getFailOnIssues()) {
                    this.mojo.getLog().warn((CharSequence)("snyk " + this.mojo.getCommand().commandName() + " did find issues, but the plugin is configured to not fail in this situation."));
                    break;
                }
            }
            default: {
                throw new MojoFailureException("snyk command exited with non-zero exit code (" + exitCode + "). See output for details.");
            }
        }
    }

    private int executeCommand() throws MojoExecutionException {
        try {
            Log log = this.mojo.getLog();
            String executablePath = this.mojo.getExecutable().orElseGet(this::downloadExecutable).getAbsolutePath();
            log.info((CharSequence)("Snyk Executable Path: " + executablePath));
            log.info((CharSequence)("Snyk CLI Version:     " + this.getVersion(executablePath)));
            ProcessBuilder commandLine = CommandLine.asProcessBuilder(executablePath, this.mojo.getCommand(), this.mojo.getApiToken(), this.mojo.getArguments(), this.mojo.supportsColor()).directory(this.getProjectRootDirectory());
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Snyk Command: " + String.join((CharSequence)" ", commandLine.command())));
            }
            return CommandRunner.run(commandLine::start, arg_0 -> ((Log)log).info(arg_0), arg_0 -> ((Log)log).error(arg_0));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private File getProjectRootDirectory() {
        MavenProject project = (MavenProject)this.mojo.getPluginContext().get("project");
        if (project == null) {
            throw new IllegalStateException("the `project` is missing from the plugin context");
        }
        return project.getBasedir();
    }

    private String getVersion(String executablePath) {
        ProcessBuilder versionCommandLine = CommandLine.asProcessBuilder(executablePath, Command.VERSION, Optional.empty(), Collections.emptyList(), false);
        ArrayList stdout = new ArrayList();
        CommandRunner.LineLogger ignore = line -> {};
        CommandRunner.run(versionCommandLine::start, stdout::add, ignore);
        return String.join((CharSequence)"", stdout).trim();
    }

    private File downloadExecutable() {
        return ExecutableDownloader.ensure(this.mojo.getDownloadUrl(), this.mojo.getDownloadDestination(), this.mojo.getUpdatePolicy(), FileDownloader::downloadFile);
    }
}

