/*
 * Decompiled with CFR 0.152.
 */
package spray.json;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeMap$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spray.json.JsArray;
import spray.json.JsArray$;
import spray.json.JsFalse$;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsNumber$;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsString;
import spray.json.JsString$;
import spray.json.JsTrue$;
import spray.json.JsValue;
import spray.json.JsonParser$;
import spray.json.JsonParserSettings;
import spray.json.JsonParserSettings$;
import spray.json.ParserInput;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mx!B\u0001\u0003\u0011\u00039\u0011A\u0003&t_:\u0004\u0016M]:fe*\u00111\u0001B\u0001\u0005UN|gNC\u0001\u0006\u0003\u0015\u0019\bO]1z\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011!BS:p]B\u000b'o]3s'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQAF\u0005\u0005\u0002]\tQ!\u00199qYf$\"\u0001G\u000e\u0011\u0005!I\u0012B\u0001\u000e\u0003\u0005\u001dQ5OV1mk\u0016DQ\u0001H\u000bA\u0002u\tQ!\u001b8qkR\u0004\"\u0001\u0003\u0010\n\u0005}\u0011!a\u0003)beN,'/\u00138qkRDQAF\u0005\u0005\u0002\u0005\"2\u0001\u0007\u0012$\u0011\u0015a\u0002\u00051\u0001\u001e\u0011\u0015!\u0003\u00051\u0001&\u0003!\u0019X\r\u001e;j]\u001e\u001c\bC\u0001\u0005'\u0013\t9#A\u0001\nKg>t\u0007+\u0019:tKJ\u001cV\r\u001e;j]\u001e\u001ch\u0001B\u0015\n\u0001)\u0012\u0001\u0003U1sg&tw-\u0012=dKB$\u0018n\u001c8\u0014\u0005!Z\u0003C\u0001\u00175\u001d\ti#G\u0004\u0002/c5\tqF\u0003\u00021\r\u00051AH]8pizJ\u0011aD\u0005\u0003g9\tq\u0001]1dW\u0006<W-\u0003\u00026m\t\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u0003g9A\u0001\u0002\u000f\u0015\u0003\u0006\u0004%\t!O\u0001\bgVlW.\u0019:z+\u0005Q\u0004CA\u001e@\u001d\taT\b\u0005\u0002/\u001d%\u0011aHD\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?\u001d!A1\t\u000bB\u0001B\u0003%!(\u0001\u0005tk6l\u0017M]=!\u0011!)\u0005F!b\u0001\n\u0003I\u0014A\u00023fi\u0006LG\u000e\u0003\u0005HQ\t\u0005\t\u0015!\u0003;\u0003\u001d!W\r^1jY\u0002BQa\u0005\u0015\u0005\u0002%#2A\u0013'N!\tY\u0005&D\u0001\n\u0011\u0015A\u0004\n1\u0001;\u0011\u001d)\u0005\n%AA\u0002i:qaT\u0005\u0002\u0002#\u0005\u0001+\u0001\tQCJ\u001c\u0018N\\4Fq\u000e,\u0007\u000f^5p]B\u00111*\u0015\u0004\bS%\t\t\u0011#\u0001S'\r\tFb\u0015\t\u0003\u001bQK!!\u0016\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bM\tF\u0011A,\u0015\u0003ACq!W)\u0012\u0002\u0013\u0005!,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u00027*\u0012!\bX\u0016\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u0019\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002e?\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000f\u0019\f\u0016\u0011!C\u0005O\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005A\u0007CA5o\u001b\u0005Q'BA6m\u0003\u0011a\u0017M\\4\u000b\u00035\fAA[1wC&\u0011qN\u001b\u0002\u0007\u001f\nTWm\u0019;\t\u000feK\u0011\u0013!C\u0001cV\t!O\u000b\u0002&9\u001a!!B\u0001\u0001u'\t\u0019H\u0002\u0003\u0005\u001dg\n\u0005\t\u0015!\u0003\u001e\u0011!!3O!A!\u0002\u0013)\u0003\"B\nt\t\u0003AHcA={wB\u0011\u0001b\u001d\u0005\u00069]\u0004\r!\b\u0005\bI]\u0004\n\u00111\u0001&\u0011\u0015\u00192\u000f\"\u0001~)\tIh\u0010C\u0003\u001dy\u0002\u0007Q\u0004\u0003\u0005\u0002\u0002M\u0004\u000b\u0011BA\u0002\u0003\t\u0019(\rE\u0002j\u0003\u000bI1!a\u0002k\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\"A\u00111B:!B\u0013\ti!\u0001\u0006dkJ\u001cxN]\"iCJ\u00042!DA\b\u0013\r\t\tB\u0004\u0002\u0005\u0007\"\f'\u000f\u0003\u0006\u0002\u0016M\u0004\r\u0011!Q!\na\tqA[:WC2,X\rC\u0004\u0002\u001aM$\t!a\u0007\u0002\u0019A\f'o]3KgZ\u000bG.^3\u0015\u0003aAq!!\u0007t\t\u0003\ty\u0002F\u0002\u0019\u0003CA\u0001\"a\t\u0002\u001e\u0001\u0007\u0011QE\u0001\u0013C2dwn\u001e+sC&d\u0017N\\4J]B,H\u000fE\u0002\u000e\u0003OI1!!\u000b\u000f\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\ft\u0005\u0004%i!a\f\u0002\u0007\u0015{\u0015*\u0006\u0002\u00022=\u0011\u00111\u0007\u000f\u0004\u0001}\u0000\u0010\u0002CA\u001cg\u0002\u0006i!!\r\u0002\t\u0015{\u0015\n\t\u0005\b\u0003w\u0019H\u0011BA\u001f\u0003\u00151\u0018\r\\;f)\u0011\ty$!\u0012\u0011\u00075\t\t%C\u0002\u0002D9\u0011A!\u00168ji\"A\u0011qIA\u001d\u0001\u0004\tI%\u0001\tsK6\f\u0017N\\5oO:+7\u000f^5oOB\u0019Q\"a\u0013\n\u0007\u00055cBA\u0002J]RDq!!\u0015t\t\u0013\t\u0019&A\u0003gC2\u001cX\r\u0006\u0002\u0002&!9\u0011qK:\u0005\n\u0005M\u0013\u0001\u00028vY2Dq!a\u0017t\t\u0013\t\u0019&\u0001\u0003ueV,\u0007bBA0g\u0012%\u0011\u0011M\u0001\u0007_\nTWm\u0019;\u0015\t\u0005}\u00121\r\u0005\t\u0003\u000f\ni\u00061\u0001\u0002J!9\u0011qM:\u0005\n\u0005%\u0014!B1se\u0006LH\u0003BA \u0003WB\u0001\"a\u0012\u0002f\u0001\u0007\u0011\u0011\n\u0005\b\u0003_\u001aH\u0011BA9\u0003\u0019qW/\u001c2feR\u0011\u0011q\b\u0005\b\u0003k\u001aH\u0011BA9\u0003\rIg\u000e\u001e\u0005\b\u0003s\u001aH\u0011BA9\u0003\u00111'/Y2\t\u000f\u0005u4\u000f\"\u0003\u0002r\u0005\u0019Q\r\u001f9\t\u000f\u0005\u00055\u000f\"\u0003\u0002r\u0005yqN\\3Pe6{'/\u001a#jO&$8\u000fC\u0004\u0002\u0006N$I!!\u001d\u0002!i,'o\\(s\u001b>\u0014X\rR5hSR\u001c\b\u0006BAB\u0003\u0013\u0003B!a#\u0002\u000e6\t\u0011-C\u0002\u0002\u0010\u0006\u0014q\u0001^1jYJ,7\rC\u0004\u0002\u0014N$I!a\u0015\u0002\u000b\u0011Ku)\u0013+\t\u000f\u0005]5\u000f\"\u0003\u0002r\u000511\u000f\u001e:j]\u001eDq!a't\t\u0013\t\u0019&\u0001\u0003dQ\u0006\u0014\bbBAPg\u0012%\u00111K\u0001\bKN\u001c\u0017\r]3e\u0011\u001d\t\u0019k\u001dC\u0005\u0003c\n!a^:)\t\u0005\u0005\u0016\u0011\u0012\u0005\b\u0003S\u001bH\u0011BAV\u0003\t\u0019\u0007\u000e\u0006\u0003\u0002&\u00055\u0006\u0002CAX\u0003O\u0003\r!!\u0004\u0002\u0003\rDq!a)t\t\u0013\t\u0019\f\u0006\u0003\u0002&\u0005U\u0006\u0002CAX\u0003c\u0003\r!!\u0004\t\u000f\u0005e6\u000f\"\u0003\u0002T\u00059\u0011\r\u001a<b]\u000e,\u0007bBA_g\u0012%\u0011qX\u0001\tCB\u0004XM\u001c3T\u0005R!\u0011QEAa\u0011!\ty+a/A\u0002\u00055\u0001bBAcg\u0012%\u0011qY\u0001\be\u0016\fX/\u001b:f)\u0011\ty$!3\t\u0011\u0005=\u00161\u0019a\u0001\u0003\u001bAq!!4t\t\u0013\ty-\u0001\u0003gC&dG\u0003CAi\u0003/\fY.a8\u0011\u00075\t\u0019.C\u0002\u0002V:\u0011qAT8uQ&tw\rC\u0004\u0002Z\u0006-\u0007\u0019\u0001\u001e\u0002\rQ\f'oZ3u\u0011)\ti.a3\u0011\u0002\u0003\u0007\u0011\u0011J\u0001\u0007GV\u00148o\u001c:\t\u0015\u0005\u0005\u00181\u001aI\u0001\u0002\u0004\ti!A\u0005feJ|'o\u00115be\"I\u0011Q]:\u0012\u0002\u0013%\u0011q]\u0001\u000fM\u0006LG\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tIOK\u0002\u0002JqC\u0011\"!<t#\u0003%I!a<\u0002\u001d\u0019\f\u0017\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u001f\u0016\u0004\u0003\u001ba\u0006")
public class JsonParser {
    private final ParserInput input;
    private final JsonParserSettings settings;
    private final StringBuilder sb;
    private char cursorChar;
    private JsValue jsValue;

    public static JsonParserSettings $lessinit$greater$default$2() {
        return JsonParser$.MODULE$.$lessinit$greater$default$2();
    }

    public static JsValue apply(ParserInput parserInput, JsonParserSettings jsonParserSettings) {
        return JsonParser$.MODULE$.apply(parserInput, jsonParserSettings);
    }

    public static JsValue apply(ParserInput parserInput) {
        return JsonParser$.MODULE$.apply(parserInput);
    }

    public JsValue parseJsValue() {
        return this.parseJsValue(false);
    }

    public JsValue parseJsValue(boolean allowTrailingInput) {
        block0: {
            this.ws();
            this.value(this.settings.maxDepth());
            if (allowTrailingInput) break block0;
            this.require('\uffff');
        }
        return this.jsValue;
    }

    private final char EOI() {
        return '\uffff';
    }

    private void value(int remainingNesting) {
        if (remainingNesting == 0) {
            throw new ParsingException("JSON input nested too deeply", new StringBuilder(76).append("JSON input was nested more deeply than the configured limit of maxNesting = ").append(this.settings.maxDepth()).toString());
        }
        int mark = this.input.cursor();
        char c = this.cursorChar;
        switch (c) {
            case 'f': {
                this.simpleValue$1(this.false(), JsFalse$.MODULE$, mark);
                break;
            }
            case 'n': {
                this.simpleValue$1(this.null(), JsNull$.MODULE$, mark);
                break;
            }
            case 't': {
                this.simpleValue$1(this.true(), JsTrue$.MODULE$, mark);
                break;
            }
            case '{': {
                this.advance();
                this.object(remainingNesting);
                break;
            }
            case '[': {
                this.advance();
                this.array(remainingNesting);
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.number();
                break;
            }
            case '\"': {
                this.string();
                this.jsValue = this.sb.length() == 0 ? JsString$.MODULE$.empty() : new JsString(this.sb.toString());
                break;
            }
            default: {
                throw this.fail("JSON Value", this.fail$default$2(), this.fail$default$3());
            }
        }
    }

    private boolean false() {
        return this.advance() && this.ch('a') && this.ch('l') && this.ch('s') && this.ws('e');
    }

    private boolean null() {
        return this.advance() && this.ch('u') && this.ch('l') && this.ws('l');
    }

    private boolean true() {
        return this.advance() && this.ch('r') && this.ch('u') && this.ws('e');
    }

    private void object(int remainingNesting) {
        JsObject jsObject;
        this.ws();
        if (this.cursorChar != '}') {
            Map map = this.members$1((Map)TreeMap$.MODULE$.empty((Ordering)Ordering.String$.MODULE$), remainingNesting);
            this.require('}');
            jsObject = new JsObject((Map<String, JsValue>)map);
        } else {
            this.advance();
            jsObject = JsObject$.MODULE$.empty();
        }
        this.jsValue = jsObject;
        this.ws();
    }

    private void array(int remainingNesting) {
        JsArray jsArray;
        this.ws();
        if (this.cursorChar != ']') {
            Builder list = scala.package$.MODULE$.Vector().newBuilder();
            this.values$1(remainingNesting, list);
            this.require(']');
            jsArray = new JsArray((Vector<JsValue>)((Vector)list.result()));
        } else {
            this.advance();
            jsArray = JsArray$.MODULE$.empty();
        }
        this.jsValue = jsArray;
        this.ws();
    }

    private void number() {
        JsNumber jsNumber;
        int start = this.input.cursor();
        char startChar = this.cursorChar;
        this.ch('-');
        this.int();
        this.frac();
        this.exp();
        int numberLength = this.input.cursor() - start;
        if (startChar == '0' && this.input.cursor() - start == 1) {
            jsNumber = JsNumber$.MODULE$.zero();
        } else if (numberLength <= this.settings.maxNumberCharacters()) {
            jsNumber = JsNumber$.MODULE$.apply(this.input.sliceCharArray(start, this.input.cursor()));
        } else {
            String numberSnippet = new String(this.input.sliceCharArray(start, package$.MODULE$.min(this.input.cursor(), start + 20)));
            throw new ParsingException("Number too long", new StringBuilder(62).append("The number starting with '").append(numberSnippet).append("' had ").append(new StringBuilder(96).append(numberLength).append(" characters which is more than the allowed limit maxNumberCharacters = ").append(this.settings.maxNumberCharacters()).append(". If this is legit input ").toString()).append("consider increasing the limit.").toString());
        }
        this.jsValue = jsNumber;
        this.ws();
    }

    private void int() {
        block0: {
            if (this.ch('0')) break block0;
            this.oneOrMoreDigits();
        }
    }

    private void frac() {
        block0: {
            if (!this.ch('.')) break block0;
            this.oneOrMoreDigits();
        }
    }

    private void exp() {
        block0: {
            if (!this.ch('e') && !this.ch('E')) break block0;
            boolean bl = this.ch('-') || this.ch('+');
            this.oneOrMoreDigits();
        }
    }

    private void oneOrMoreDigits() {
        if (!this.DIGIT()) {
            throw this.fail("DIGIT", this.fail$default$2(), this.fail$default$3());
        }
        this.zeroOrMoreDigits();
    }

    private void zeroOrMoreDigits() {
        while (this.DIGIT()) {
        }
    }

    private boolean DIGIT() {
        return this.cursorChar >= '0' && this.cursorChar <= '9' && this.advance();
    }

    private void string() {
        if (this.cursorChar != '\"') {
            throw this.fail("'\"'", this.fail$default$2(), this.fail$default$3());
        }
        this.cursorChar = this.input.nextUtf8Char();
        this.sb.setLength(0);
        while (this.char()) {
            this.cursorChar = this.input.nextUtf8Char();
        }
        this.require('\"');
        this.ws();
    }

    private boolean char() {
        boolean bl;
        if ((1L << this.cursorChar & (long)(31 - this.cursorChar >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = this.appendSB(this.cursorChar);
        } else {
            char c = this.cursorChar;
            switch (c) {
                case '\"': 
                case '\uffff': {
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.escaped();
                    break;
                }
                default: {
                    if (c >= ' ' && this.appendSB(c)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private boolean escaped() {
        boolean bl;
        char c = this.cursorChar;
        switch (c) {
            case '\"': 
            case '/': 
            case '\\': {
                bl = this.appendSB(this.cursorChar);
                break;
            }
            case 'b': {
                bl = this.appendSB('\b');
                break;
            }
            case 'f': {
                bl = this.appendSB('\f');
                break;
            }
            case 'n': {
                bl = this.appendSB('\n');
                break;
            }
            case 'r': {
                bl = this.appendSB('\r');
                break;
            }
            case 't': {
                bl = this.appendSB('\t');
                break;
            }
            case 'u': {
                this.advance();
                bl = this.unicode$1();
                break;
            }
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar & (long)(this.cursorChar - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean advance() {
        this.cursorChar = this.input.nextChar();
        return true;
    }

    private boolean appendSB(char c) {
        this.sb.append(c);
        return true;
    }

    private void require(char c) {
        if (!this.ch(c)) {
            throw this.fail(new StringBuilder(2).append("'").append(c).append("'").toString(), this.fail$default$2(), this.fail$default$3());
        }
    }

    private Nothing$ fail(String target, int cursor, char errorChar) {
        String string;
        ParserInput.Line line = this.input.getLine(cursor);
        if (line == null) {
            throw new MatchError((Object)line);
        }
        int lineNr = line.lineNr();
        int col = line.column();
        String text = line.text();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)lineNr), (Object)BoxesRunTime.boxToInteger((int)col), (Object)text);
        Tuple3 tuple32 = tuple3;
        int lineNr2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int col2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        String text2 = (String)tuple32._3();
        if (errorChar != '\uffff') {
            String c2 = Character.isISOControl(errorChar) ? new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorChar)})) : ((Object)BoxesRunTime.boxToCharacter((char)errorChar)).toString();
            string = new StringBuilder(12).append("character '").append(c2).append("'").toString();
        } else {
            string = "end-of-input";
        }
        String unexpected = string;
        String string2 = target;
        String string3 = "'\uffff'";
        String expected = (string2 == null ? string3 != null : !string2.equals(string3)) ? target : "end-of-input";
        String summary = new StringBuilder(57).append("Unexpected ").append(unexpected).append(" at input index ").append(cursor).append(" (line ").append(lineNr2).append(", position ").append(col2).append("), expected ").append(expected).toString();
        String sanitizedText = (String)new StringOps(Predef$.MODULE$.augmentString(text2)).map((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToCharacter((char)JsonParser.$anonfun$fail$1(BoxesRunTime.unboxToChar((Object)c))), Predef$.MODULE$.StringCanBuildFrom());
        String detail = new StringBuilder(4).append("\n").append(sanitizedText).append("\n").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(col2 - 1)).append("^\n").toString();
        throw new ParsingException(summary, detail);
    }

    private int fail$default$2() {
        return this.input.cursor();
    }

    private char fail$default$3() {
        return this.cursorChar;
    }

    private final void simpleValue$1(boolean matched, JsValue value, int mark$1) {
        if (!matched) {
            throw this.fail("JSON Value", mark$1, this.fail$default$3());
        }
        this.jsValue = value;
    }

    private final Map members$1(Map map, int remainingNesting$1) {
        Map nextMap;
        while (true) {
            this.string();
            this.require(':');
            this.ws();
            String key = this.sb.toString();
            this.value(remainingNesting$1 - 1);
            nextMap = map.updated((Object)key, (Object)this.jsValue);
            if (!this.ws(',')) break;
            map = nextMap;
        }
        return nextMap;
    }

    private final void values$1(int remainingNesting$2, Builder list$1) {
        do {
            this.value(remainingNesting$2 - 1);
            list$1.$plus$eq((Object)this.jsValue);
        } while (this.ws(','));
    }

    private final int hexValue$1(char c) {
        int n;
        if ('0' <= c && c <= '9') {
            n = c - 48;
        } else if ('a' <= c && c <= 'f') {
            n = c - 87;
        } else if ('A' <= c && c <= 'F') {
            n = c - 55;
        } else {
            throw this.fail("hex digit", this.fail$default$2(), this.fail$default$3());
        }
        return n;
    }

    private final boolean unicode$1() {
        int value = this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        this.advance();
        value = (value << 4) + this.hexValue$1(this.cursorChar);
        return this.appendSB((char)value);
    }

    public static final /* synthetic */ char $anonfun$fail$1(char c) {
        return Character.isISOControl(c) ? (char)'?' : (char)c;
    }

    public JsonParser(ParserInput input, JsonParserSettings settings) {
        this.input = input;
        this.settings = settings;
        this.sb = new StringBuilder();
        this.cursorChar = input.nextChar();
    }

    public JsonParser(ParserInput input) {
        this(input, JsonParserSettings$.MODULE$.default());
    }

    public static class ParsingException
    extends RuntimeException {
        private final String summary;
        private final String detail;

        public String summary() {
            return this.summary;
        }

        public String detail() {
            return this.detail;
        }

        public ParsingException(String summary, String detail) {
            this.summary = summary;
            this.detail = detail;
            super(summary.isEmpty() ? detail : (detail.isEmpty() ? summary : new StringBuilder(1).append(summary).append(":").append(detail).toString()));
        }
    }
}

