/*
 * Decompiled with CFR 0.152.
 */
package io.spring.asciidoctor.backend.codetools;

import io.spring.asciidoctor.backend.codetools.ChompOption;
import io.spring.asciidoctor.backend.codetools.ListingContentConverter;
import io.spring.asciidoctor.backend.codetools.Options;
import io.spring.asciidoctor.backend.language.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.ContentNode;

public class ChompListingContentConverter
implements ListingContentConverter {
    private static final String PACKAGE_REPLACEMENT_ATTR = "chomp_package_replacement";

    @Override
    public String convert(Block listingBlock, String content) {
        Options options = Options.get((Block)listingBlock, (String)"chomp", ChompOption.class, (Enum[])ChompOption.DEFAULTS);
        String packageReplacement = (String)listingBlock.getAttribute((Object)PACKAGE_REPLACEMENT_ATTR, listingBlock.getDocument().getAttribute((Object)PACKAGE_REPLACEMENT_ATTR));
        Language language = Language.get((ContentNode)listingBlock);
        if (Language.isJavaLike(language)) {
            ArrayList<Chomper> chompers = new ArrayList<Chomper>();
            if (options.has(ChompOption.HEADERS)) {
                chompers.add(new HeaderChomper(language));
            }
            if (options.has(ChompOption.PACKAGES)) {
                chompers.add(new PackageChomper(language, packageReplacement));
            }
            if (options.has(ChompOption.TAGS)) {
                chompers.add(new TagChomper());
            }
            if (options.has(ChompOption.FORMATTERS)) {
                chompers.add(new FormatterChomper());
            }
            if (options.has(ChompOption.SUPPRESSWARNINGS)) {
                chompers.add(new SuppressWarningsChomper());
            }
            return this.chomp(content, chompers);
        }
        return content;
    }

    private String chomp(String content, List<Chomper> chompers) {
        for (Chomper chomper : chompers) {
            content = chomper.chomp(content);
        }
        return content;
    }

    private static class SuppressWarningsChomper
    implements Chomper {
        private static final List<Pattern> PATTERNS;

        private SuppressWarningsChomper() {
        }

        @Override
        public String chomp(String content) {
            String[] lines;
            StringBuilder result = new StringBuilder(content.length());
            for (String line : lines = content.split("\n")) {
                String strippedline = this.strip(line);
                if (!strippedline.equals(line) && strippedline.trim().isEmpty()) continue;
                result.append(strippedline);
                result.append("\n");
            }
            return result.toString();
        }

        private String strip(String line) {
            for (Pattern pattern : PATTERNS) {
                line = pattern.matcher(line).replaceAll("");
            }
            return line;
        }

        static {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            patterns.add(Pattern.compile("@SuppressWarnings\\(.*\\)"));
            patterns.add(Pattern.compile("@Suppress\\(.*\\)"));
            PATTERNS = Collections.unmodifiableList(patterns);
        }
    }

    private static class FormatterChomper
    implements Chomper {
        private static final Pattern PATTERN = Pattern.compile("^[\\ \\t]*\\/\\/\\s*@formatter:(on|off).*$\n?", 8);

        private FormatterChomper() {
        }

        @Override
        public String chomp(String content) {
            return PATTERN.matcher(content).replaceAll("");
        }
    }

    private static class TagChomper
    implements Chomper {
        private static final Pattern SHORT_PATTERN = Pattern.compile("\\/\\*\\*\\/.*$", 8);
        private static final Pattern LINE_PATTERN = Pattern.compile("\\/\\*\\s*@chomp:line(.*)\\*\\/.*$", 8);
        private static final Pattern SINGLE_LINE_PATTERN = Pattern.compile("\\/\\/\\s*@chomp:line(.*)$", 8);
        private static final Pattern FILE_PATTERN = Pattern.compile("(\\/\\/|\\/\\*)\\s*@chomp:file");

        private TagChomper() {
        }

        @Override
        public String chomp(String content) {
            content = this.chompShortPatterns(content);
            content = this.chompLinePatterns(LINE_PATTERN, content);
            content = this.chompLinePatterns(SINGLE_LINE_PATTERN, content);
            content = this.chompFilePatterns(content);
            return content;
        }

        private String chompShortPatterns(String content) {
            return SHORT_PATTERN.matcher(content).replaceAll("...");
        }

        private String chompLinePatterns(Pattern pattern, String content) {
            StringBuffer buffer = new StringBuffer();
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                matcher.appendReplacement(buffer, matcher.group(1).trim());
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }

        private String chompFilePatterns(String content) {
            Matcher matcher = FILE_PATTERN.matcher(content);
            if (matcher.find()) {
                StringBuffer buffer = new StringBuffer();
                matcher.appendReplacement(buffer, "");
                return buffer.toString();
            }
            return content;
        }
    }

    private static class PackageChomper
    implements Chomper {
        private static Pattern pattern;
        private final String replacement;

        PackageChomper(Language language, String replacement) {
            pattern = Pattern.compile("package\\ [\\w\\.]+" + language.getStatementTerminator() + "\\s*", 32);
            this.replacement = replacement != null && !replacement.isEmpty() ? "package " + replacement + language.getStatementTerminator() + "\n\n" : "";
        }

        @Override
        public String chomp(String content) {
            return pattern.matcher(content).replaceFirst(this.replacement);
        }
    }

    private static class HeaderChomper
    implements Chomper {
        private final Pattern pattern;

        HeaderChomper(Language language) {
            this.pattern = Pattern.compile("^.*?(package\\ [\\w\\.]+" + language.getStatementTerminator() + ")", 32);
        }

        @Override
        public String chomp(String content) {
            Matcher matcher = this.pattern.matcher(content);
            if (matcher.find()) {
                StringBuffer updated = new StringBuffer();
                matcher.appendReplacement(updated, matcher.group(1));
                matcher.appendTail(updated);
                return updated.toString();
            }
            return content;
        }
    }

    private static interface Chomper {
        public String chomp(String var1);
    }
}

