/*
 * Decompiled with CFR 0.152.
 */
package io.spring.asciidoctor.backend.language;

import org.asciidoctor.ast.ContentNode;

public enum Language {
    JAVA("Java", "docs-java", "java", true, ";"),
    KOTLIN("Kotlin", "docs-kotlin", "kt", true, ""),
    GROOVY("Groovy", "docs-groovy", "groovy", true, "");

    private final String title;
    private final String pathAttribute;
    private final String extension;
    private final boolean javaLike;
    private final String statementTerminator;

    private Language(String title, String pathAttribute, String extension, boolean javaLike, String statementTerminator) {
        this.title = title;
        this.pathAttribute = pathAttribute;
        this.extension = extension;
        this.javaLike = javaLike;
        this.statementTerminator = statementTerminator;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPathAttribute() {
        return this.pathAttribute;
    }

    public String GetExtension() {
        return this.extension;
    }

    public String getId() {
        return this.name().toLowerCase();
    }

    public boolean isJavaLike() {
        return this.javaLike;
    }

    public String getStatementTerminator() {
        return this.statementTerminator;
    }

    public static Language get(ContentNode node) {
        String language = (String)node.getAttribute((Object)"language");
        for (Language candidate : Language.values()) {
            if (!candidate.getId().equals(language)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean isJavaLike(Language language) {
        return language != null && language.isJavaLike();
    }
}

