/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.filters.SuppressFilterElement;
import io.spring.javaformat.checkstyle.FilteredModuleFactory;
import io.spring.javaformat.checkstyle.SpringConfigurationLoader;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class SpringChecks
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    private ClassLoader classLoader;
    private ModuleFactory moduleFactory;
    private Collection<FileSetCheck> checks;
    private String headerType = "apache2";
    private String headerCopyrightPattern = "20\\d\\d(-20\\d\\d)?";
    private String headerFile;
    private Set<String> avoidStaticImportExcludes = Collections.emptySet();
    private String projectRootPackage = "org.springframework";
    private Set<String> excludes;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    public void finishLocalSetup() {
        FilteredModuleFactory moduleFactory = new FilteredModuleFactory(this.moduleFactory, this.excludes);
        DefaultContext context = new DefaultContext();
        context.add("classLoader", (Object)this.classLoader);
        context.add("severity", (Object)this.getSeverity());
        context.add("tabWidth", (Object)String.valueOf(this.getTabWidth()));
        context.add("moduleFactory", (Object)moduleFactory);
        Properties properties = new Properties();
        this.put(properties, "headerType", this.headerType);
        this.put(properties, "headerCopyrightPattern", this.headerCopyrightPattern);
        this.put(properties, "headerFile", this.headerFile);
        this.put(properties, "projectRootPackage", this.projectRootPackage);
        this.put(properties, "avoidStaticImportExcludes", this.avoidStaticImportExcludes.stream().collect(Collectors.joining(",")));
        this.checks = new SpringConfigurationLoader((Context)context, moduleFactory).load((PropertyResolver)new PropertiesExpander(properties));
    }

    private void put(Properties properties, String name, Object value) {
        if (value != null) {
            properties.put(name, value);
        }
    }

    public Set<String> getExternalResourceLocations() {
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        for (FileSetCheck check : this.checks) {
            if (!(check instanceof ExternalResourceHolder)) continue;
            locations.addAll(((ExternalResourceHolder)check).getExternalResourceLocations());
        }
        return locations;
    }

    public void beginProcessing(String charset) {
        super.beginProcessing(charset);
        try {
            SuppressFilterElement filter = new SuppressFilterElement("[\\\\/]src[\\\\/]test[\\\\/]java[\\\\/]", "Javadoc*", null, null, null, null);
            ((Checker)this.getMessageDispatcher()).addFilter((Filter)filter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        TreeSet violations = new TreeSet();
        for (FileSetCheck check : this.checks) {
            violations.addAll(check.process(file, fileText));
        }
        this.addViolations(violations);
    }

    public void setupChild(Configuration configuration) throws CheckstyleException {
        throw new CheckstyleException("SpringChecks is not allowed as a parent of " + configuration.getName());
    }

    public void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    public void setHeaderCopyrightPattern(String headerCopyrightPattern) {
        this.headerCopyrightPattern = headerCopyrightPattern;
    }

    public void setHeaderFile(String headerFile) {
        this.headerFile = headerFile;
    }

    public void setAvoidStaticImportExcludes(String[] avoidStaticImportExcludes) {
        this.avoidStaticImportExcludes = new LinkedHashSet<String>(Arrays.asList(avoidStaticImportExcludes));
    }

    public void setProjectRootPackage(String projectRootPackage) {
        this.projectRootPackage = projectRootPackage;
    }

    public void setExcludes(String ... excludes) {
        this.excludes = new HashSet<String>(Arrays.asList(excludes));
    }
}

