/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;

public class SpringTestFileNameCheck
extends AbstractFileSetCheck {
    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        String path = file.getPath().replace('\\', '/');
        if (path.contains("src/test/java") && file.getName().endsWith("Test.java")) {
            this.visitCompilationUnit(JavaParser.parseFileText((FileText)fileText, (JavaParser.Options)JavaParser.Options.WITHOUT_COMMENTS));
        }
    }

    private void visitCompilationUnit(DetailAST ast) {
        for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 14) continue;
            this.log(1, "testfilename.wrongName", new Object[0]);
            return;
        }
    }
}

