/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core;

public final class Flags {
    public static boolean isAbstract(int flags) {
        return (flags & 0x400) != 0;
    }

    public static boolean isDeprecated(int flags) {
        return (flags & 0x100000) != 0;
    }

    public static boolean isFinal(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean isInterface(int flags) {
        return (flags & 0x200) != 0;
    }

    public static boolean isNative(int flags) {
        return (flags & 0x100) != 0;
    }

    public static boolean isPrivate(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isProtected(int flags) {
        return (flags & 4) != 0;
    }

    public static boolean isPublic(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isStatic(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isStrictfp(int flags) {
        return (flags & 0x800) != 0;
    }

    public static boolean isSynchronized(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isTransient(int flags) {
        return (flags & 0x80) != 0;
    }

    public static boolean isVolatile(int flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean isVarargs(int flags) {
        return (flags & 0x80) != 0;
    }

    public static boolean isEnum(int flags) {
        return (flags & 0x4000) != 0;
    }

    public static boolean isSealed(int flags) {
        return (flags & 0x10000000) != 0;
    }

    public static boolean isDefaultMethod(int flags) {
        return (flags & 0x10000) != 0;
    }

    public static String toString(int flags) {
        int len;
        StringBuffer sb = new StringBuffer();
        if (Flags.isPublic(flags)) {
            sb.append("public ");
        }
        if (Flags.isProtected(flags)) {
            sb.append("protected ");
        }
        if (Flags.isPrivate(flags)) {
            sb.append("private ");
        }
        if (Flags.isAbstract(flags)) {
            sb.append("abstract ");
        }
        if (Flags.isDefaultMethod(flags)) {
            sb.append("default ");
        }
        if (Flags.isStatic(flags)) {
            sb.append("static ");
        }
        if (Flags.isFinal(flags)) {
            sb.append("final ");
        }
        if (Flags.isSynchronized(flags)) {
            sb.append("synchronized ");
        }
        if (Flags.isNative(flags)) {
            sb.append("native ");
        }
        if (Flags.isStrictfp(flags)) {
            sb.append("strictfp ");
        }
        if (Flags.isTransient(flags)) {
            sb.append("transient ");
        }
        if (Flags.isVolatile(flags)) {
            sb.append("volatile ");
        }
        if ((len = sb.length()) == 0) {
            return "";
        }
        sb.setLength(len - 1);
        return sb.toString();
    }
}

