/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.ClasspathContainerInitializer;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ClasspathVariableInitializer;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IAccessRule;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathContainer;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaModel;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.WorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.DefaultWorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModel;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.SetContainerOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.MementoTokenizer;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public final class JavaCore
extends Plugin {
    private static final IResource[] NO_GENERATED_RESOURCES = new IResource[0];
    private static Plugin JAVA_CORE_PLUGIN = null;
    private static List<String> allVersions = Collections.unmodifiableList(Arrays.asList("cldc1.1", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "9", "10", "11", "12", "13", "14", "15"));

    public static List<String> getAllVersions() {
        return allVersions;
    }

    public JavaCore() {
        JAVA_CORE_PLUGIN = this;
    }

    public static IJavaElement create(String handleIdentifier) {
        return JavaCore.create(handleIdentifier, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaElement create(String handleIdentifier, WorkingCopyOwner owner) {
        if (handleIdentifier == null) {
            return null;
        }
        if (owner == null) {
            owner = DefaultWorkingCopyOwner.PRIMARY;
        }
        MementoTokenizer memento = new MementoTokenizer(handleIdentifier);
        JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
        return model.getHandleFromMemento(memento, owner);
    }

    public static IJavaElement create(IFile file) {
        return JavaModelManager.create(file, null);
    }

    public static IJavaProject create(IProject project) {
        if (project == null) {
            return null;
        }
        JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
        return javaModel.getJavaProject((IResource)project);
    }

    public static IJavaElement create(IResource resource) {
        return JavaModelManager.create(resource, null);
    }

    public static IJavaModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public static IClasspathContainer getClasspathContainer(IPath containerPath, IJavaProject project) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        IClasspathContainer container = manager.getClasspathContainer(containerPath, project);
        if (container == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
            return manager.getPreviousSessionContainer(containerPath, project);
        }
        return container;
    }

    public static ClasspathContainerInitializer getClasspathContainerInitializer(String containerID) {
        Hashtable<String, ClasspathContainerInitializer> containerInitializersCache = JavaModelManager.getJavaModelManager().containerInitializersCache;
        ClasspathContainerInitializer initializer = containerInitializersCache.get(containerID);
        if (initializer == null) {
            initializer = JavaCore.computeClasspathContainerInitializer(containerID);
            if (initializer == null) {
                return null;
            }
            containerInitializersCache.put(containerID, initializer);
        }
        return initializer;
    }

    private static ClasspathContainerInitializer computeClasspathContainerInitializer(String containerID) {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("io.spring.javaformat.eclipse.jdt.jdk8.core", "classpathContainerInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    block9: {
                        IConfigurationElement configurationElement = configElements[j];
                        String initializerID = configurationElement.getAttribute("id");
                        if (initializerID != null && initializerID.equals(containerID)) {
                            if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                                JavaCore.verbose_found_container_initializer(containerID, configurationElement);
                            }
                            try {
                                Object execExt = configurationElement.createExecutableExtension("class");
                                if (execExt instanceof ClasspathContainerInitializer) {
                                    return (ClasspathContainerInitializer)execExt;
                                }
                            }
                            catch (CoreException e) {
                                if (!JavaModelManager.CP_RESOLVE_VERBOSE && !JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) break block9;
                                JavaCore.verbose_failed_to_instanciate_container_initializer(containerID, configurationElement);
                                e.printStackTrace();
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private static void verbose_failed_to_instanciate_container_initializer(String containerID, IConfigurationElement configurationElement) {
        Util.verbose("CPContainer INIT - failed to instanciate initializer\n\tcontainer ID: " + containerID + '\n' + "\tclass: " + configurationElement.getAttribute("class"), System.err);
    }

    private static void verbose_found_container_initializer(String containerID, IConfigurationElement configurationElement) {
        Util.verbose("CPContainer INIT - found initializer\n\tcontainer ID: " + containerID + '\n' + "\tclass: " + configurationElement.getAttribute("class"));
    }

    public static IPath getClasspathVariable(String variableName) {
        IPath variablePath;
        block17: {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            variablePath = manager.variableGet(variableName);
            if (variablePath == JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                return manager.getPreviousSessionVariable(variableName);
            }
            if (variablePath != null) {
                if (variablePath == JavaModelManager.CP_ENTRY_IGNORE_PATH) {
                    return null;
                }
                return variablePath;
            }
            ClasspathVariableInitializer initializer = JavaCore.getClasspathVariableInitializer(variableName);
            if (initializer != null) {
                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                    JavaCore.verbose_triggering_variable_initialization(variableName, initializer);
                }
                if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                    JavaCore.verbose_triggering_variable_initialization_invocation_trace();
                }
                manager.variablePut(variableName, JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS);
                boolean ok = false;
                try {
                    initializer.initialize(variableName);
                    variablePath = manager.variableGet(variableName);
                    if (variablePath == JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                        return null;
                    }
                    try {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                            JavaCore.verbose_variable_value_after_initialization(variableName, variablePath);
                        }
                        manager.variablesWithInitializer.add(variableName);
                        ok = true;
                        break block17;
                    }
                    catch (Error | RuntimeException e) {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                            e.printStackTrace();
                        }
                        throw e;
                    }
                }
                finally {
                    if (!ok) {
                        JavaModelManager.getJavaModelManager().variablePut(variableName, null);
                    }
                }
            }
            if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                JavaCore.verbose_no_variable_initializer_found(variableName);
            }
        }
        return variablePath;
    }

    private static void verbose_no_variable_initializer_found(String variableName) {
        Util.verbose("CPVariable INIT - no initializer found\n\tvariable: " + variableName);
    }

    private static void verbose_variable_value_after_initialization(String variableName, IPath variablePath) {
        Util.verbose("CPVariable INIT - after initialization\n\tvariable: " + variableName + '\n' + "\tvariable path: " + variablePath);
    }

    private static void verbose_triggering_variable_initialization(String variableName, ClasspathVariableInitializer initializer) {
        Util.verbose("CPVariable INIT - triggering initialization\n\tvariable: " + variableName + '\n' + "\tinitializer: " + initializer);
    }

    private static void verbose_triggering_variable_initialization_invocation_trace() {
        Util.verbose("CPVariable INIT - triggering initialization\n\tinvocation trace:");
        new Exception("<Fake exception>").printStackTrace(System.out);
    }

    public static String getClasspathVariableDeprecationMessage(String variableName) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        String message = manager.deprecatedVariables.get(variableName);
        if (message != null) {
            return message;
        }
        IPath variablePath = manager.variableGet(variableName);
        if (variablePath != null && variablePath != JavaModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
            return null;
        }
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("io.spring.javaformat.eclipse.jdt.jdk8.core", "classpathVariableInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String deprecatedAttribute;
                    IConfigurationElement configElement = configElements[j];
                    String varAttribute = configElement.getAttribute("variable");
                    if (variableName.equals(varAttribute) && (deprecatedAttribute = configElement.getAttribute("deprecated")) != null) {
                        return deprecatedAttribute;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static ClasspathVariableInitializer getClasspathVariableInitializer(String variable) {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("io.spring.javaformat.eclipse.jdt.jdk8.core", "classpathVariableInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    block11: {
                        IConfigurationElement configElement = configElements[j];
                        try {
                            String varAttribute = configElement.getAttribute("variable");
                            if (variable.equals(varAttribute)) {
                                Object execExt;
                                if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                                    JavaCore.verbose_found_variable_initializer(variable, configElement);
                                }
                                if ((execExt = configElement.createExecutableExtension("class")) instanceof ClasspathVariableInitializer) {
                                    String readOnlyAttribute;
                                    ClasspathVariableInitializer initializer = (ClasspathVariableInitializer)execExt;
                                    String deprecatedAttribute = configElement.getAttribute("deprecated");
                                    if (deprecatedAttribute != null) {
                                        JavaModelManager.getJavaModelManager().deprecatedVariables.put(variable, deprecatedAttribute);
                                    }
                                    if ("true".equals(readOnlyAttribute = configElement.getAttribute("readOnly"))) {
                                        JavaModelManager.getJavaModelManager().readOnlyVariables.add(variable);
                                    }
                                    return initializer;
                                }
                            }
                        }
                        catch (CoreException e) {
                            if (!JavaModelManager.CP_RESOLVE_VERBOSE && !JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) break block11;
                            JavaCore.verbose_failed_to_instanciate_variable_initializer(variable, configElement);
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    private static void verbose_failed_to_instanciate_variable_initializer(String variable, IConfigurationElement configElement) {
        Util.verbose("CPContainer INIT - failed to instanciate initializer\n\tvariable: " + variable + '\n' + "\tclass: " + configElement.getAttribute("class"), System.err);
    }

    private static void verbose_found_variable_initializer(String variable, IConfigurationElement configElement) {
        Util.verbose("CPVariable INIT - found initializer\n\tvariable: " + variable + '\n' + "\tclass: " + configElement.getAttribute("class"));
    }

    public static Hashtable<String, String> getDefaultOptions() {
        return JavaModelManager.getJavaModelManager().getDefaultOptions();
    }

    public static String getEncoding() {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (IllegalStateException illegalStateException) {
            return System.getProperty("file.encoding");
        }
        catch (CoreException coreException) {
            return ResourcesPlugin.getEncoding();
        }
    }

    public static JavaCore getJavaCore() {
        return (JavaCore)JavaCore.getPlugin();
    }

    public static String getOption(String optionName) {
        return JavaModelManager.getJavaModelManager().getOption(optionName);
    }

    public static Hashtable<String, String> getOptions() {
        return JavaModelManager.getJavaModelManager().getOptions();
    }

    public static Plugin getPlugin() {
        return JAVA_CORE_PLUGIN;
    }

    public static IClasspathEntry getResolvedClasspathEntry(IClasspathEntry entry) {
        return JavaModelManager.getJavaModelManager().resolveVariableEntry(entry, false);
    }

    public static IPath getResolvedVariablePath(IPath variablePath) {
        return JavaModelManager.getJavaModelManager().getResolvedVariablePath(variablePath, false);
    }

    public static IAccessRule newAccessRule(IPath filePattern, int kind) {
        return JavaModelManager.getJavaModelManager().getAccessRule(filePattern, kind);
    }

    public static IClasspathEntry newContainerEntry(IPath containerPath, IAccessRule[] accessRules, IClasspathAttribute[] extraAttributes, boolean isExported) {
        if (containerPath == null) {
            throw new ClasspathEntry.AssertionFailedException("Container path cannot be null");
        }
        if (containerPath.segmentCount() < 1) {
            throw new ClasspathEntry.AssertionFailedException("Illegal classpath container path: '" + containerPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)");
        }
        if (accessRules == null || accessRules.length == 0) {
            accessRules = ClasspathEntry.NO_ACCESS_RULES;
        }
        if (extraAttributes == null || extraAttributes.length == 0) {
            extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        }
        return new ClasspathEntry(1, 5, containerPath, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, isExported, accessRules, true, extraAttributes);
    }

    public static IClasspathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IAccessRule[] accessRules, IClasspathAttribute[] extraAttributes, boolean isExported) {
        boolean hasDotDot;
        if (path == null) {
            throw new ClasspathEntry.AssertionFailedException("Library path cannot be null");
        }
        if (accessRules == null || accessRules.length == 0) {
            accessRules = ClasspathEntry.NO_ACCESS_RULES;
        }
        if (extraAttributes == null || extraAttributes.length == 0) {
            extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        }
        if (!(hasDotDot = ClasspathEntry.hasDotDot(path)) && !path.isAbsolute()) {
            throw new ClasspathEntry.AssertionFailedException("Path for IClasspathEntry must be absolute: " + path);
        }
        if (sourceAttachmentPath != null) {
            if (sourceAttachmentPath.isEmpty()) {
                sourceAttachmentPath = null;
            } else if (!sourceAttachmentPath.isAbsolute()) {
                throw new ClasspathEntry.AssertionFailedException("Source attachment path '" + sourceAttachmentPath + "' for IClasspathEntry must be absolute");
            }
        }
        return new ClasspathEntry(2, 1, hasDotDot ? path : JavaProject.canonicalizedPath(path), ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, sourceAttachmentPath, sourceAttachmentRootPath, null, isExported, accessRules, false, extraAttributes);
    }

    public static IClasspathEntry newProjectEntry(IPath path, IAccessRule[] accessRules, boolean combineAccessRules, IClasspathAttribute[] extraAttributes, boolean isExported) {
        if (!path.isAbsolute()) {
            throw new ClasspathEntry.AssertionFailedException("Path for IClasspathEntry must be absolute");
        }
        if (accessRules == null || accessRules.length == 0) {
            accessRules = ClasspathEntry.NO_ACCESS_RULES;
        }
        if (extraAttributes == null || extraAttributes.length == 0) {
            extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        }
        return new ClasspathEntry(1, 2, path, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, isExported, accessRules, combineAccessRules, extraAttributes);
    }

    public static IClasspathEntry newSourceEntry(IPath path) {
        return JavaCore.newSourceEntry(path, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IPath specificOutputLocation) {
        return JavaCore.newSourceEntry(path, inclusionPatterns, exclusionPatterns, specificOutputLocation, ClasspathEntry.NO_EXTRA_ATTRIBUTES);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IPath specificOutputLocation, IClasspathAttribute[] extraAttributes) {
        if (path == null) {
            throw new ClasspathEntry.AssertionFailedException("Source path cannot be null");
        }
        if (!path.isAbsolute()) {
            throw new ClasspathEntry.AssertionFailedException("Path for IClasspathEntry must be absolute");
        }
        if (exclusionPatterns == null) {
            exclusionPatterns = ClasspathEntry.EXCLUDE_NONE;
        }
        if (inclusionPatterns == null) {
            inclusionPatterns = ClasspathEntry.INCLUDE_ALL;
        }
        if (extraAttributes == null) {
            extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        }
        return new ClasspathEntry(1, 3, path, inclusionPatterns, exclusionPatterns, null, null, specificOutputLocation, false, null, false, extraAttributes);
    }

    public static IClasspathEntry newVariableEntry(IPath variablePath, IPath variableSourceAttachmentPath, IPath variableSourceAttachmentRootPath, IAccessRule[] accessRules, IClasspathAttribute[] extraAttributes, boolean isExported) {
        if (variablePath == null) {
            throw new ClasspathEntry.AssertionFailedException("Variable path cannot be null");
        }
        if (variablePath.segmentCount() < 1) {
            throw new ClasspathEntry.AssertionFailedException("Illegal classpath variable path: '" + variablePath.makeRelative().toString() + "', must have at least one segment");
        }
        if (accessRules == null || accessRules.length == 0) {
            accessRules = ClasspathEntry.NO_ACCESS_RULES;
        }
        if (extraAttributes == null || extraAttributes.length == 0) {
            extraAttributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        }
        return new ClasspathEntry(1, 4, variablePath, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, variableSourceAttachmentPath, variableSourceAttachmentRootPath, null, isExported, accessRules, false, extraAttributes);
    }

    public static void setClasspathContainer(IPath containerPath, IJavaProject[] affectedProjects, IClasspathContainer[] respectiveContainers, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject project;
        JavaModelManager manager;
        IClasspathContainer existingCointainer;
        IClasspathContainer container;
        if (affectedProjects.length != respectiveContainers.length) {
            throw new ClasspathEntry.AssertionFailedException("Projects and containers collections should have the same size");
        }
        if (affectedProjects.length == 1 && (container = respectiveContainers[0]) != null && (existingCointainer = (manager = JavaModelManager.getJavaModelManager()).containerGet(project = affectedProjects[0], containerPath)) == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
            manager.containerBeingInitializedPut(project, containerPath, container);
            return;
        }
        SetContainerOperation operation = new SetContainerOperation(containerPath, affectedProjects, respectiveContainers);
        operation.runOperation(monitor);
    }

    public static int compareJavaVersions(String first, String second) {
        return Long.compare(CompilerOptions.versionToJdkLevel(first), CompilerOptions.versionToJdkLevel(second));
    }
}

