/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Block;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildListPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.IMethodBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimplePropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.VariableDeclaration;
import java.util.ArrayList;
import java.util.List;

public class LambdaExpression
extends Expression {
    public static final SimplePropertyDescriptor PARENTHESES_PROPERTY = new SimplePropertyDescriptor(LambdaExpression.class, "parentheses", Boolean.TYPE, true);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(LambdaExpression.class, "parameters", VariableDeclaration.class, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(LambdaExpression.class, "body", ASTNode.class, true, true);
    private static final List PROPERTY_DESCRIPTORS_8_0;
    private boolean hasParentheses = true;
    private ASTNode.NodeList parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    private ASTNode body = null;

    static {
        ArrayList propertyList = new ArrayList(4);
        LambdaExpression.createPropertyList(LambdaExpression.class, propertyList);
        LambdaExpression.addProperty(PARENTHESES_PROPERTY, propertyList);
        LambdaExpression.addProperty(PARAMETERS_PROPERTY, propertyList);
        LambdaExpression.addProperty(BODY_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_8_0 = LambdaExpression.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS_8_0;
    }

    LambdaExpression(AST ast) {
        super(ast);
        this.unsupportedIn2_3_4();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return LambdaExpression.propertyDescriptors(apiLevel);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == PARENTHESES_PROPERTY) {
            if (get) {
                return this.hasParentheses();
            }
            this.setParentheses(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody(child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 86;
    }

    @Override
    ASTNode clone0(AST target) {
        LambdaExpression result = new LambdaExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setParentheses(this.hasParentheses());
        result.parameters().addAll(ASTNode.copySubtrees(target, this.parameters()));
        result.setBody(ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.parameters);
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public boolean hasParentheses() {
        return this.hasParentheses;
    }

    public void setParentheses(boolean hasParentheses) {
        this.preValueChange(PARENTHESES_PROPERTY);
        this.hasParentheses = hasParentheses;
        this.postValueChange(PARENTHESES_PROPERTY);
    }

    public List parameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASTNode getBody() {
        if (this.body == null) {
            LambdaExpression lambdaExpression = this;
            synchronized (lambdaExpression) {
                if (this.body == null) {
                    this.preLazyInit();
                    this.body = new Block(this.ast);
                    this.postLazyInit(this.body, BODY_PROPERTY);
                }
            }
        }
        return this.body;
    }

    public void setBody(ASTNode body) {
        if (!(body instanceof Expression) && !(body instanceof Block)) {
            throw new IllegalArgumentException();
        }
        ASTNode oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public IMethodBinding resolveMethodBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }

    @Override
    int memSize() {
        return 52;
    }

    @Override
    int treeSize() {
        return this.memSize() + this.parameters.listSize() + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

