/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildListPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimplePropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Statement;
import java.util.ArrayList;
import java.util.List;

public class SwitchCase
extends Statement {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(SwitchCase.class, "expression", Expression.class, false, true);
    public static final ChildListPropertyDescriptor EXPRESSIONS2_PROPERTY = new ChildListPropertyDescriptor(SwitchCase.class, "expression", Expression.class, true);
    public static final SimplePropertyDescriptor SWITCH_LABELED_RULE_PROPERTY = new SimplePropertyDescriptor(SwitchCase.class, "switchLabeledRule", Boolean.TYPE, true);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_13;
    private Expression optionalExpression = null;
    private boolean switchLabeledRule = false;
    private ASTNode.NodeList expressions = null;
    private boolean expressionInitialized = false;

    static {
        ArrayList propertyList = new ArrayList(2);
        SwitchCase.createPropertyList(SwitchCase.class, propertyList);
        SwitchCase.addProperty(EXPRESSION_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = SwitchCase.reapPropertyList(propertyList);
        propertyList = new ArrayList(2);
        SwitchCase.createPropertyList(SwitchCase.class, propertyList);
        SwitchCase.addProperty(EXPRESSIONS2_PROPERTY, propertyList);
        SwitchCase.addProperty(SWITCH_LABELED_RULE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_13 = SwitchCase.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel >= 14) {
            return PROPERTY_DESCRIPTORS_13;
        }
        return PROPERTY_DESCRIPTORS;
    }

    SwitchCase(AST ast) {
        super(ast);
        if (ast.apiLevel >= 14) {
            this.expressions = new ASTNode.NodeList(this, EXPRESSIONS2_PROPERTY);
        }
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SwitchCase.propertyDescriptors(apiLevel);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == SWITCH_LABELED_RULE_PROPERTY) {
            if (get) {
                return this.isSwitchLabeledRule();
            }
            this.setSwitchLabeledRule(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == EXPRESSIONS2_PROPERTY) {
            return this.expressions();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 49;
    }

    @Override
    ASTNode clone0(AST target) {
        SwitchCase result = new SwitchCase(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        if (this.ast.apiLevel >= 14) {
            result.expressions().addAll(ASTNode.copySubtrees(target, this.expressions()));
        } else {
            result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        }
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel >= 14) {
                this.acceptChildren(visitor, this.expressions);
            } else {
                this.acceptChild(visitor, this.getExpression());
            }
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getExpression() {
        if (!this.expressionInitialized) {
            SwitchCase switchCase = this;
            synchronized (switchCase) {
                if (!this.expressionInitialized) {
                    this.preLazyInit();
                    this.optionalExpression = new SimpleName(this.ast);
                    this.expressionInitialized = true;
                    this.postLazyInit(this.optionalExpression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this.optionalExpression;
    }

    public List expressions() {
        if (this.expressions == null) {
            this.unsupportedBelow14();
        }
        return this.expressions;
    }

    public void setExpression(Expression expression) {
        Expression oldChild = this.optionalExpression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.optionalExpression = expression;
        this.expressionInitialized = true;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public void setSwitchLabeledRule(boolean switchLabeledRule) {
        this.unsupportedBelow14();
        this.preValueChange(SWITCH_LABELED_RULE_PROPERTY);
        this.switchLabeledRule = switchLabeledRule;
        this.postValueChange(SWITCH_LABELED_RULE_PROPERTY);
    }

    public boolean isSwitchLabeledRule() {
        this.unsupportedBelow14();
        return this.switchLabeledRule;
    }

    public boolean isDefault() {
        if (this.ast.apiLevel >= 14) {
            return this.expressions().isEmpty();
        }
        return this.getExpression() == null;
    }

    @Override
    int memSize() {
        return super.memSize() + 8;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.optionalExpression == null ? 0 : this.optionalExpression.treeSize());
    }
}

