/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.IJavadocTypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.SingleTypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.Constant;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.Binding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.BlockScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ClassScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.LocalTypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.PackageBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ProblemReferenceBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ReferenceBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.Scope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding;

public class JavadocSingleTypeReference
extends SingleTypeReference
implements IJavadocTypeReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public PackageBinding packageBinding;

    public JavadocSingleTypeReference(char[] source, long pos, int tagStart, int tagEnd) {
        super(source, pos);
        this.tagSourceStart = tagStart;
        this.tagSourceEnd = tagEnd;
        this.bits |= 0x8000;
    }

    @Override
    protected TypeBinding internalResolveType(Scope scope, int location) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding type = this.resolvedType.closestMatch();
                    return type;
                }
            }
            return null;
        }
        this.resolvedType = this.getTypeBinding(scope);
        if (this.resolvedType instanceof LocalTypeBinding) {
            LocalTypeBinding localType = (LocalTypeBinding)this.resolvedType;
            if (localType.scope != null && localType.scope.parent == scope) {
                this.resolvedType = new ProblemReferenceBinding(new char[][]{localType.sourceName}, (ReferenceBinding)this.resolvedType, 1);
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.isValidBinding()) {
            char[][] tokens = new char[][]{this.token};
            Binding binding = scope.getTypeOrPackage(tokens);
            if (binding instanceof PackageBinding) {
                this.packageBinding = (PackageBinding)binding;
            } else {
                TypeBinding closestMatch;
                if (this.resolvedType.problemId() == 7 && (closestMatch = this.resolvedType.closestMatch()) != null && closestMatch.isTypeVariable()) {
                    this.resolvedType = closestMatch;
                    return this.resolvedType;
                }
                this.reportInvalidType(scope);
            }
            return null;
        }
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(this.resolvedType, scope);
        }
        if (this.resolvedType.isGenericType() || this.resolvedType.isParameterizedType()) {
            this.resolvedType = scope.environment().convertToRawType(this.resolvedType, true);
        }
        return this.resolvedType;
    }

    @Override
    protected void reportDeprecatedType(TypeBinding type, Scope scope) {
        scope.problemReporter().javadocDeprecatedType(type, this, scope.getDeclarationModifiers());
    }

    @Override
    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().javadocInvalidType(this, this.resolvedType, scope.getDeclarationModifiers());
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    @Override
    public int getTagSourceStart() {
        return this.tagSourceStart;
    }

    @Override
    public int getTagSourceEnd() {
        return this.tagSourceEnd;
    }
}

