/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.WorkingCopyOwner;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CategorizedProblem;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.CompilationResult;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.Compiler;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.DefaultErrorHandlingPolicies;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ICompilerRequestor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.IErrorHandlingPolicy;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.IProblemFactory;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.SourceElementParser;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.CompilationUnitDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.AccessRestriction;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.INameEnvironment;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.ISourceType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.LookupEnvironment;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.PackageBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeConstants;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.parser.SourceTypeConverter;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.problem.AbortCompilation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CancelableNameEnvironment;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CancelableProblemFactory;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ModuleDescriptionInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.NameLookup;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.SourceTypeElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.CommentRecorderParser;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class CompilationUnitProblemFinder
extends Compiler {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions compilerOptions, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, compilerOptions, requestor, problemFactory);
    }

    @Override
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        while (sourceTypes[0].getEnclosingType() != null) {
            sourceTypes[0] = sourceTypes[0].getEnclosingType();
        }
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        long savedComplianceLevel = this.options.complianceLevel;
        long savedSourceLevel = this.options.sourceLevel;
        LookupEnvironment environment = packageBinding.environment;
        if (environment == null) {
            environment = this.lookupEnvironment;
        }
        try {
            IJavaProject project = ((SourceTypeElementInfo)sourceTypes[0]).getHandle().getJavaProject();
            this.options.complianceLevel = CompilerOptions.versionToJdkLevel(project.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.compliance", true));
            this.options.sourceLevel = CompilerOptions.versionToJdkLevel(project.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.source", true));
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, environment.problemReporter, result);
            if (unit != null) {
                environment.buildTypeBindings(unit, accessRestriction);
                CompilationUnitDeclaration previousUnitBeingCompleted = this.lookupEnvironment.unitBeingCompleted;
                environment.completeTypeBindings(unit);
                this.lookupEnvironment.unitBeingCompleted = previousUnitBeingCompleted;
            }
        }
        finally {
            this.options.complianceLevel = savedComplianceLevel;
            this.options.sourceLevel = savedSourceLevel;
        }
    }

    @Override
    public void accept(IModule module, LookupEnvironment environment) {
        IModuleDescription handle = null;
        if (module instanceof ModuleDescriptionInfo) {
            handle = ((ModuleDescriptionInfo)module).getHandle();
        }
        if (handle == null) {
            super.accept(module, environment);
            return;
        }
        CompilationResult result = new CompilationResult(TypeConstants.MODULE_INFO_FILE_NAME, 1, 1, this.options.maxProblemsPerUnit);
        long savedComplianceLevel = this.options.complianceLevel;
        long savedSourceLevel = this.options.sourceLevel;
        if (environment == null) {
            environment = this.lookupEnvironment;
        }
        try {
            IJavaProject project = handle.getJavaProject();
            this.options.complianceLevel = CompilerOptions.versionToJdkLevel(project.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.compliance", true));
            this.options.sourceLevel = CompilerOptions.versionToJdkLevel(project.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.source", true));
            CompilationUnitDeclaration unit = SourceTypeConverter.buildModularCompilationUnit(module, environment.problemReporter, result);
            if (unit != null) {
                environment.buildTypeBindings(unit, null);
                environment.completeTypeBindings(unit);
            }
        }
        finally {
            this.options.complianceLevel = savedComplianceLevel;
            this.options.sourceLevel = savedSourceLevel;
        }
    }

    protected static CompilerOptions getCompilerOptions(Map settings, boolean creatingAST, boolean statementsRecovery) {
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        compilerOptions.performMethodsFullRecovery = statementsRecovery;
        compilerOptions.performStatementsRecovery = statementsRecovery;
        boolean bl = compilerOptions.parseLiteralExpressionsAsConstants = !creatingAST;
        if (creatingAST) {
            compilerOptions.storeAnnotations = true;
        }
        return compilerOptions;
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            @Override
            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isTestSource(IJavaProject project, ICompilationUnit cu) {
        try {
            IClasspathEntry[] resolvedClasspath = project.getResolvedClasspath(true);
            IPath resourcePath = cu.getResource().getFullPath();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3 && e.isTest() && e.getPath().isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Util.log((Throwable)((Object)e), "Exception while determining if compilation unit \"" + cu.getElementName() + "\" is test source");
        }
        return false;
    }

    public static CompilationUnitDeclaration process(CompilationUnit unitElement, SourceElementParser parser, WorkingCopyOwner workingCopyOwner, HashMap problems, boolean creatingAST, int reconcileFlags, IProgressMonitor monitor) throws JavaModelException {
        JavaProject project = (JavaProject)unitElement.getJavaProject();
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        CompilationUnitProblemFinder problemFinder = null;
        CompilationUnitDeclaration unit = null;
        try {
            try {
                boolean ignoreMethodBodies;
                environment = new CancelableNameEnvironment(project, workingCopyOwner, monitor, !CompilationUnitProblemFinder.isTestSource(unitElement.getJavaProject(), unitElement));
                problemFactory = new CancelableProblemFactory(monitor);
                CompilerOptions compilerOptions = CompilationUnitProblemFinder.getCompilerOptions(project.getOptions(true), creatingAST, (reconcileFlags & 2) != 0);
                compilerOptions.ignoreMethodBodies = ignoreMethodBodies = (reconcileFlags & 8) != 0;
                problemFinder = new CompilationUnitProblemFinder(environment, CompilationUnitProblemFinder.getHandlingPolicy(), compilerOptions, CompilationUnitProblemFinder.getRequestor(), problemFactory);
                boolean analyzeAndGenerateCode = true;
                if (ignoreMethodBodies) {
                    analyzeAndGenerateCode = false;
                }
                try {
                    if (parser != null) {
                        problemFinder.parser = parser;
                        unit = parser.parseCompilationUnit(unitElement, true, monitor);
                        problemFinder.resolve(unit, unitElement, true, analyzeAndGenerateCode, analyzeAndGenerateCode);
                    } else {
                        unit = problemFinder.resolve(unitElement, true, analyzeAndGenerateCode, analyzeAndGenerateCode);
                    }
                }
                catch (AbortCompilation e) {
                    problemFinder.handleInternalException(e, unit);
                }
                if (unit != null) {
                    CategorizedProblem[] categorizedProblems;
                    int length;
                    CompilationResult unitResult = unit.compilationResult;
                    CategorizedProblem[] unitProblems = unitResult.getCUProblems();
                    int n = length = unitProblems == null ? 0 : unitProblems.length;
                    if (length > 0) {
                        categorizedProblems = new CategorizedProblem[length];
                        System.arraycopy(unitProblems, 0, categorizedProblems, 0, length);
                        problems.put("io.spring.javaformat.eclipse.jdt.jdk8.core.problem", categorizedProblems);
                    }
                    int n2 = length = (unitProblems = unitResult.getTasks()) == null ? 0 : unitProblems.length;
                    if (length > 0) {
                        categorizedProblems = new CategorizedProblem[length];
                        System.arraycopy(unitProblems, 0, categorizedProblems, 0, length);
                        problems.put("io.spring.javaformat.eclipse.jdt.jdk8.core.task", categorizedProblems);
                    }
                    if (NameLookup.VERBOSE) {
                        System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
                        System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
                    }
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                String lineDelimiter = unitElement.findRecommendedLineSeparator();
                StringBuffer message = new StringBuffer("Exception occurred during problem detection:");
                message.append(lineDelimiter);
                message.append("----------------------------------- SOURCE BEGIN -------------------------------------");
                message.append(lineDelimiter);
                message.append(unitElement.getSource());
                message.append(lineDelimiter);
                message.append("----------------------------------- SOURCE END -------------------------------------");
                Util.log(e, message.toString());
                throw new JavaModelException(e, 1005);
            }
        }
        finally {
            if (environment != null) {
                environment.setMonitor(null);
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            if (problemFinder != null && !creatingAST) {
                problemFinder.lookupEnvironment.reset();
            }
        }
        return unit;
    }

    public static CompilationUnitDeclaration process(CompilationUnit unitElement, WorkingCopyOwner workingCopyOwner, HashMap problems, boolean creatingAST, int reconcileFlags, IProgressMonitor monitor) throws JavaModelException {
        return CompilationUnitProblemFinder.process(unitElement, null, workingCopyOwner, problems, creatingAST, reconcileFlags, monitor);
    }

    @Override
    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }
}

