/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.builder;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IModulePathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IMultiModuleEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.builder.ClasspathDirectory;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.builder.ClasspathJar;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.builder.ClasspathLocation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;

public class ModulePathEntry
implements IModulePathEntry {
    private IPath path;
    ClasspathLocation[] locations;
    IModule module;
    boolean isAutomaticModule;

    ModulePathEntry(IPath path, IModule module, ClasspathLocation[] locations) {
        this.path = path;
        this.locations = locations;
        this.module = module;
        this.isAutomaticModule = module.isAutomatic();
        this.initializeModule();
    }

    public ModulePathEntry(IPath path, ClasspathLocation location) {
        this.path = path;
        this.initModule(location);
        this.locations = new ClasspathLocation[]{location};
    }

    public ClasspathLocation[] getClasspathLocations() {
        return this.locations;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public boolean isAutomaticModule() {
        return this.isAutomaticModule;
    }

    public static IModule getAutomaticModule(ClasspathLocation location) {
        if (location instanceof ClasspathJar) {
            ClasspathJar classpathJar = (ClasspathJar)location;
            return IModule.createAutomatic(classpathJar.zipFilename, true, classpathJar.getManifest());
        }
        if (location instanceof ClasspathDirectory) {
            return IModule.createAutomatic(((ClasspathDirectory)location).binaryFolder.getName(), false, null);
        }
        return null;
    }

    private void initModule(ClasspathLocation location) {
        IModule mod = null;
        if (location instanceof ClasspathJar) {
            mod = ((ClasspathJar)location).initializeModule();
        } else if (location instanceof ClasspathDirectory) {
            mod = ((ClasspathDirectory)location).initializeModule();
        }
        if (mod != null) {
            this.module = mod;
            this.isAutomaticModule = false;
        } else {
            this.module = ModulePathEntry.getAutomaticModule(location);
            this.isAutomaticModule = true;
        }
        location.setModule(this.module);
    }

    private void initializeModule() {
        int i = 0;
        while (i < this.locations.length) {
            this.locations[i].setModule(this.module);
            ++i;
        }
    }

    @Override
    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        if (!(moduleName == null || this.module != null && moduleName.equals(String.valueOf(this.module.name())))) {
            return null;
        }
        char[][] names = CharOperation.NO_CHAR_CHAR;
        ClasspathLocation[] classpathLocationArray = this.locations;
        int n = this.locations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathLocation cp = classpathLocationArray[n2];
            char[][] declaringModules = cp.getModulesDeclaringPackage(qualifiedPackageName, moduleName);
            if (declaringModules != null) {
                names = CharOperation.arrayConcat(names, declaringModules);
            }
            ++n2;
        }
        return names == CharOperation.NO_CHAR_CHAR ? null : names;
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        ClasspathLocation[] classpathLocationArray = this.locations;
        int n = this.locations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathLocation cp = classpathLocationArray[n2];
            if (cp.hasCompilationUnit(qualifiedPackageName, moduleName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public char[][] listPackages() {
        char[][] packages = CharOperation.NO_CHAR_CHAR;
        if (this.isAutomaticModule) {
            ClasspathLocation[] classpathLocationArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                ClasspathLocation cp = classpathLocationArray[n2];
                packages = CharOperation.arrayConcat(packages, cp.listPackages());
                ++n2;
            }
            return packages;
        }
        return packages;
    }

    public static class Multi
    extends ModulePathEntry
    implements IMultiModuleEntry {
        Multi(IPath path, IModule module, ClasspathLocation[] locations) {
            super(path, module, locations);
        }

        void addPatchLocation(ClasspathLocation location) {
            this.locations = Arrays.copyOf(this.locations, this.locations.length + 1);
            this.locations[this.locations.length - 1] = location;
            location.setModule(this.module);
        }

        @Override
        public IModule getModule(char[] name) {
            ClasspathLocation[] classpathLocationArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                IModule mod;
                ClasspathLocation loc = classpathLocationArray[n2];
                if (loc instanceof IMultiModuleEntry ? (mod = ((IMultiModuleEntry)((Object)loc)).getModule(name)) != null : CharOperation.equals((mod = loc.getModule()).name(), name)) {
                    return mod;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public Collection<String> getModuleNames(Collection<String> limitModules) {
            HashSet<String> result = new HashSet<String>();
            ClasspathLocation[] classpathLocationArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                ClasspathLocation loc = classpathLocationArray[n2];
                if (loc instanceof IMultiModuleEntry) {
                    result.addAll(((IMultiModuleEntry)((Object)loc)).getModuleNames(limitModules));
                } else {
                    result.add(String.valueOf(loc.getModule().name()));
                }
                ++n2;
            }
            return result;
        }
    }
}

