/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IAnnotationComponent;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IExtendedAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ILocalVariableReferenceInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.AnnotationComponent;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileStruct;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.LocalVariableReferenceInfo;

public class ExtendedAnnotation
extends ClassFileStruct
implements IExtendedAnnotation {
    private static final IAnnotationComponent[] NO_ENTRIES = new IAnnotationComponent[0];
    private static final int[][] NO_TYPEPATH = new int[0][0];
    private static final ILocalVariableReferenceInfo[] NO_LOCAL_VARIABLE_TABLE_ENTRIES = new ILocalVariableReferenceInfo[0];
    private int targetType;
    private int annotationTypeIndex;
    private int[][] typePath;
    private int typeIndex;
    private char[] typeName;
    private int componentsNumber;
    private IAnnotationComponent[] components;
    private int readOffset;
    private int offset;
    private int typeParameterIndex;
    private int typeParameterBoundIndex;
    private int parameterIndex;
    private int exceptionTableIndex;
    private ILocalVariableReferenceInfo[] localVariableTable = NO_LOCAL_VARIABLE_TABLE_ENTRIES;

    public ExtendedAnnotation(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int length;
        IConstantPoolEntry constantPoolEntry;
        int index;
        this.targetType = index = this.u1At(classFileBytes, 0, offset);
        this.readOffset = 1;
        this.readTargetInfo(index, classFileBytes, constantPool, offset);
        index = this.u1At(classFileBytes, this.readOffset, offset);
        ++this.readOffset;
        int typePathEntryCount = index;
        if (typePathEntryCount == 0) {
            this.typePath = NO_TYPEPATH;
        } else {
            this.typePath = new int[typePathEntryCount][];
            int i = 0;
            while (i < typePathEntryCount) {
                this.typePath[i] = new int[2];
                int[] typePathEntry = this.typePath[i];
                typePathEntry[0] = this.u1At(classFileBytes, this.readOffset++, offset);
                typePathEntry[1] = this.u1At(classFileBytes, this.readOffset++, offset);
                ++i;
            }
        }
        this.typeIndex = index = this.u2At(classFileBytes, this.readOffset, offset);
        this.readOffset += 2;
        if (index != 0) {
            constantPoolEntry = constantPool.decodeEntry(index);
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
        } else {
            throw new ClassFormatException(3);
        }
        this.typeName = constantPoolEntry.getUtf8Value();
        this.componentsNumber = length = this.u2At(classFileBytes, this.readOffset, offset);
        this.readOffset += 2;
        if (length != 0) {
            this.components = new IAnnotationComponent[length];
            int i = 0;
            while (i < length) {
                AnnotationComponent component = new AnnotationComponent(classFileBytes, constantPool, offset + this.readOffset);
                this.components[i] = component;
                this.readOffset += component.sizeInBytes();
                ++i;
            }
        } else {
            this.components = NO_ENTRIES;
        }
        if (this.annotationTypeIndex == 65535) {
            this.annotationTypeIndex = -1;
        }
    }

    private void readTargetInfo(int localTargetType, byte[] classFileBytes, IConstantPool constantPool, int localOffset) throws ClassFormatException {
        switch (localTargetType) {
            case 0: 
            case 1: {
                this.typeParameterIndex = this.u1At(classFileBytes, this.readOffset, localOffset);
                ++this.readOffset;
                break;
            }
            case 16: {
                this.annotationTypeIndex = this.u2At(classFileBytes, this.readOffset, localOffset);
                this.readOffset += 2;
                break;
            }
            case 17: 
            case 18: {
                this.typeParameterIndex = this.u1At(classFileBytes, this.readOffset, localOffset);
                ++this.readOffset;
                this.typeParameterBoundIndex = this.u1At(classFileBytes, this.readOffset, localOffset);
                ++this.readOffset;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                this.parameterIndex = this.u1At(classFileBytes, this.readOffset, localOffset);
                ++this.readOffset;
                break;
            }
            case 23: {
                this.annotationTypeIndex = this.u2At(classFileBytes, this.readOffset, localOffset);
                this.readOffset += 2;
                break;
            }
            case 64: 
            case 65: {
                int tableLength = this.u2At(classFileBytes, this.readOffset, localOffset);
                this.readOffset += 2;
                this.localVariableTable = new LocalVariableReferenceInfo[tableLength];
                int i = 0;
                while (i < tableLength) {
                    this.localVariableTable[i] = new LocalVariableReferenceInfo(classFileBytes, constantPool, this.readOffset + localOffset);
                    this.readOffset += 6;
                    ++i;
                }
                break;
            }
            case 66: {
                this.exceptionTableIndex = this.u2At(classFileBytes, this.readOffset, localOffset);
                this.readOffset += 2;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.offset = this.u2At(classFileBytes, this.readOffset, localOffset);
                this.readOffset += 2;
                break;
            }
            case 71: {
                this.offset = this.u2At(classFileBytes, this.readOffset, localOffset);
                this.readOffset += 2;
                this.annotationTypeIndex = this.u1At(classFileBytes, this.readOffset, localOffset);
                ++this.readOffset;
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                this.offset = this.u2At(classFileBytes, this.readOffset, localOffset);
                this.readOffset += 2;
                this.annotationTypeIndex = this.u1At(classFileBytes, this.readOffset, localOffset);
                ++this.readOffset;
            }
        }
    }

    @Override
    public int getTypeIndex() {
        return this.typeIndex;
    }

    @Override
    public IAnnotationComponent[] getComponents() {
        return this.components;
    }

    int sizeInBytes() {
        return this.readOffset;
    }

    @Override
    public char[] getTypeName() {
        return this.typeName;
    }

    @Override
    public int getTargetType() {
        return this.targetType;
    }

    @Override
    public int getExceptionTableIndex() {
        return this.exceptionTableIndex;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLocalVariableRefenceInfoLength() {
        return this.localVariableTable.length;
    }

    @Override
    public ILocalVariableReferenceInfo[] getLocalVariableTable() {
        return this.localVariableTable;
    }

    @Override
    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Override
    public int getTypeParameterIndex() {
        return this.typeParameterIndex;
    }

    @Override
    public int getTypeParameterBoundIndex() {
        return this.typeParameterBoundIndex;
    }

    @Override
    public int[][] getTypePath() {
        return this.typePath;
    }

    @Override
    public int getAnnotationTypeIndex() {
        return this.annotationTypeIndex;
    }
}

