/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IInnerClassesAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IInnerClassesAttributeEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.InnerClassesAttributeEntry;

public class InnerClassesAttribute
extends ClassFileAttribute
implements IInnerClassesAttribute {
    private static final IInnerClassesAttributeEntry[] NO_ENTRIES = new IInnerClassesAttributeEntry[0];
    private int numberOfClasses;
    private IInnerClassesAttributeEntry[] entries;

    public InnerClassesAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length = this.numberOfClasses = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.entries = new IInnerClassesAttributeEntry[length];
            int i = 0;
            while (i < length) {
                this.entries[i] = new InnerClassesAttributeEntry(classFileBytes, constantPool, offset + readOffset);
                readOffset += 8;
                ++i;
            }
        } else {
            this.entries = NO_ENTRIES;
        }
    }

    @Override
    public IInnerClassesAttributeEntry[] getInnerClassAttributesEntries() {
        return this.entries;
    }
}

