/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ILocalVariableTypeTableAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ILocalVariableTypeTableEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.LocalVariableTypeTableEntry;

public class LocalVariableTypeAttribute
extends ClassFileAttribute
implements ILocalVariableTypeTableAttribute {
    private static final ILocalVariableTypeTableEntry[] NO_ENTRIES = new ILocalVariableTypeTableEntry[0];
    private int localVariableTypeTableLength;
    private ILocalVariableTypeTableEntry[] localVariableTypeTableEntries;

    public LocalVariableTypeAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.localVariableTypeTableLength = length = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.localVariableTypeTableEntries = new ILocalVariableTypeTableEntry[length];
            int i = 0;
            while (i < length) {
                this.localVariableTypeTableEntries[i] = new LocalVariableTypeTableEntry(classFileBytes, constantPool, offset + readOffset);
                readOffset += 10;
                ++i;
            }
        } else {
            this.localVariableTypeTableEntries = NO_ENTRIES;
        }
    }

    @Override
    public ILocalVariableTypeTableEntry[] getLocalVariableTypeTable() {
        return this.localVariableTypeTableEntries;
    }

    @Override
    public int getLocalVariableTypeTableLength() {
        return this.localVariableTypeTableLength;
    }
}

