/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPoolEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.INestHostAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;

public class NestHostAttribute
extends ClassFileAttribute
implements INestHostAttribute {
    private int hostIndex;
    private char[] hostName;

    public NestHostAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int index;
        this.hostIndex = index = this.u2At(classFileBytes, 6, offset);
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(index);
        if (constantPoolEntry.getKind() != 7) {
            throw new ClassFormatException(3);
        }
        this.hostName = constantPoolEntry.getClassInfoName();
    }

    @Override
    public char[] getNestHostName() {
        return this.hostName;
    }

    @Override
    public int getNestHostIndex() {
        return this.hostIndex;
    }

    public String toString() {
        return new String(this.hostName);
    }
}

