/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IParameterAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IRuntimeVisibleParameterAnnotationsAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ParameterAnnotation;

public class RuntimeVisibleParameterAnnotationsAttribute
extends ClassFileAttribute
implements IRuntimeVisibleParameterAnnotationsAttribute {
    private static final IParameterAnnotation[] NO_ENTRIES = new IParameterAnnotation[0];
    private int parametersNumber;
    private IParameterAnnotation[] parameterAnnotations;

    public RuntimeVisibleParameterAnnotationsAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.parametersNumber = length = this.u1At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 7;
            this.parameterAnnotations = new IParameterAnnotation[length];
            int i = 0;
            while (i < length) {
                ParameterAnnotation parameterAnnotation = new ParameterAnnotation(classFileBytes, constantPool, offset + readOffset);
                this.parameterAnnotations[i] = parameterAnnotation;
                readOffset += parameterAnnotation.sizeInBytes();
                ++i;
            }
        } else {
            this.parameterAnnotations = NO_ENTRIES;
        }
    }

    @Override
    public IParameterAnnotation[] getParameterAnnotations() {
        return this.parameterAnnotations;
    }
}

