/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.CompletionContext;
import io.spring.javaformat.eclipse.jdt.jdk8.core.CompletionProposal;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.IProblem;

public abstract class CompletionRequestor {
    private int ignoreSet = 0;
    private String[] favoriteReferences;
    private int[] requiredProposalAllowSet = null;
    private boolean requireExtendedContext = false;

    public CompletionRequestor() {
        this(false);
    }

    public CompletionRequestor(boolean ignoreAll) {
        this.ignoreSet = ignoreAll ? -1 : 0;
    }

    public boolean isIgnored(int completionProposalKind) {
        if (completionProposalKind < 1 || completionProposalKind > 29) {
            throw new IllegalArgumentException("Unknown kind of completion proposal: " + completionProposalKind);
        }
        return (this.ignoreSet & 1 << completionProposalKind) != 0;
    }

    public boolean isAllowingRequiredProposals(int proposalKind, int requiredProposalKind) {
        if (proposalKind < 1 || proposalKind > 29) {
            throw new IllegalArgumentException("Unknown kind of completion proposal: " + requiredProposalKind);
        }
        if (requiredProposalKind < 1 || requiredProposalKind > 29) {
            throw new IllegalArgumentException("Unknown required kind of completion proposal: " + requiredProposalKind);
        }
        if (this.requiredProposalAllowSet == null) {
            return false;
        }
        return (this.requiredProposalAllowSet[proposalKind] & 1 << requiredProposalKind) != 0;
    }

    public String[] getFavoriteReferences() {
        return this.favoriteReferences;
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void completionFailure(IProblem problem) {
    }

    public abstract void accept(CompletionProposal var1);

    public void acceptContext(CompletionContext context) {
    }

    public boolean isExtendedContextRequired() {
        return this.requireExtendedContext;
    }

    public boolean isTestCodeExcluded() {
        return false;
    }
}

