/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.ITypeRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.IProblem;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AbstractTypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildListPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Comment;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.DefaultCommentMapper;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ImportDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Message;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ModuleDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.PackageDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.parser.Scanner;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CompilationUnit
extends ASTNode {
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    public static final ChildListPropertyDescriptor IMPORTS_PROPERTY = new ChildListPropertyDescriptor(CompilationUnit.class, "imports", ImportDeclaration.class, false);
    public static final ChildPropertyDescriptor PACKAGE_PROPERTY = new ChildPropertyDescriptor(CompilationUnit.class, "package", PackageDeclaration.class, false, false);
    public static final ChildPropertyDescriptor MODULE_PROPERTY = new ChildPropertyDescriptor(CompilationUnit.class, "module", ModuleDeclaration.class, false, false);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_9_0;
    public static final ChildListPropertyDescriptor TYPES_PROPERTY;
    private DefaultCommentMapper commentMapper = null;
    private ITypeRoot typeRoot = null;
    private ASTNode.NodeList imports = new ASTNode.NodeList(IMPORTS_PROPERTY);
    private int[] lineEndTable = Util.EMPTY_INT_ARRAY;
    private List optionalCommentList = null;
    Comment[] optionalCommentTable = null;
    private PackageDeclaration optionalPackageDeclaration = null;
    private ModuleDeclaration module = null;
    private IProblem[] problems = EMPTY_PROBLEMS;
    private Object statementsRecoveryData;
    private ASTNode.NodeList types = new ASTNode.NodeList(TYPES_PROPERTY);

    static {
        TYPES_PROPERTY = new ChildListPropertyDescriptor(CompilationUnit.class, "types", AbstractTypeDeclaration.class, true);
        ArrayList properyList = new ArrayList(4);
        CompilationUnit.createPropertyList(CompilationUnit.class, properyList);
        CompilationUnit.addProperty(PACKAGE_PROPERTY, properyList);
        CompilationUnit.addProperty(IMPORTS_PROPERTY, properyList);
        CompilationUnit.addProperty(TYPES_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = CompilationUnit.reapPropertyList(properyList);
        properyList = new ArrayList(5);
        CompilationUnit.createPropertyList(CompilationUnit.class, properyList);
        CompilationUnit.addProperty(PACKAGE_PROPERTY, properyList);
        CompilationUnit.addProperty(IMPORTS_PROPERTY, properyList);
        CompilationUnit.addProperty(TYPES_PROPERTY, properyList);
        CompilationUnit.addProperty(MODULE_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_9_0 = CompilationUnit.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel < 9) {
            return PROPERTY_DESCRIPTORS;
        }
        return PROPERTY_DESCRIPTORS_9_0;
    }

    CompilationUnit(AST ast) {
        super(ast);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel >= 9) {
                this.acceptChild(visitor, this.getModule());
            }
            this.acceptChild(visitor, this.getPackage());
            this.acceptChildren(visitor, this.imports);
            this.acceptChildren(visitor, this.types);
        }
        visitor.endVisit(this);
    }

    @Override
    ASTNode clone0(AST target) {
        CompilationUnit result = new CompilationUnit(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        if (this.ast.apiLevel >= 9) {
            result.setModule((ModuleDeclaration)ASTNode.copySubtree(target, this.getModule()));
        }
        result.setPackage((PackageDeclaration)ASTNode.copySubtree(target, this.getPackage()));
        result.imports().addAll(ASTNode.copySubtrees(target, this.imports()));
        result.types().addAll(ASTNode.copySubtrees(target, this.types()));
        return result;
    }

    public List getCommentList() {
        return this.optionalCommentList;
    }

    public int getExtendedLength(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return node.getLength();
        }
        return this.commentMapper.getExtendedLength(node);
    }

    public int getExtendedStartPosition(ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.commentMapper == null || node.getAST() != this.getAST()) {
            return node.getStartPosition();
        }
        return this.commentMapper.getExtendedStartPosition(node);
    }

    @Override
    final int getNodeType0() {
        return 15;
    }

    public ModuleDeclaration getModule() {
        this.unsupportedBelow9();
        return this.module;
    }

    public PackageDeclaration getPackage() {
        return this.optionalPackageDeclaration;
    }

    public int getPosition(int line, int column) {
        int currentLineEnd;
        if (this.lineEndTable == null) {
            return -2;
        }
        if (line < 1 || column < 0) {
            return -1;
        }
        int length = this.lineEndTable.length;
        if (length == 0) {
            if (line != 1) {
                return -1;
            }
            return column >= this.getStartPosition() + this.getLength() ? -1 : column;
        }
        if (line == 1) {
            int endOfLine = this.lineEndTable[0];
            return column > endOfLine ? -1 : column;
        }
        if (line > length + 1) {
            return -1;
        }
        int previousLineOffset = this.lineEndTable[line - 2];
        int offsetForLine = previousLineOffset + 1;
        int n = currentLineEnd = line == length + 1 ? this.getStartPosition() + this.getLength() - 1 : this.lineEndTable[line - 1];
        if (offsetForLine + column > currentLineEnd) {
            return -1;
        }
        return offsetForLine + column;
    }

    public IProblem[] getProblems() {
        return this.problems;
    }

    public Object getStatementsRecoveryData() {
        return this.statementsRecoveryData;
    }

    public ITypeRoot getTypeRoot() {
        return this.typeRoot;
    }

    public List imports() {
        return this.imports;
    }

    void initCommentMapper(Scanner scanner) {
        this.commentMapper = new DefaultCommentMapper(this.optionalCommentTable);
        this.commentMapper.initialize(this, scanner);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == IMPORTS_PROPERTY) {
            return this.imports();
        }
        if (property == TYPES_PROPERTY) {
            return this.types();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == MODULE_PROPERTY) {
            if (get) {
                return this.getModule();
            }
            this.setModule((ModuleDeclaration)child);
            return null;
        }
        if (property == PACKAGE_PROPERTY) {
            if (get) {
                return this.getPackage();
            }
            this.setPackage((PackageDeclaration)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return CompilationUnit.propertyDescriptors(apiLevel);
    }

    public int getLineNumber(int position) {
        if (this.lineEndTable == null) {
            return -2;
        }
        int length = this.lineEndTable.length;
        if (length == 0) {
            if (position >= this.getStartPosition() + this.getLength()) {
                return -1;
            }
            return 1;
        }
        int low = 0;
        if (position < 0) {
            return -1;
        }
        if (position <= this.lineEndTable[low]) {
            return 1;
        }
        int hi = length - 1;
        if (position > this.lineEndTable[hi]) {
            if (position >= this.getStartPosition() + this.getLength()) {
                return -1;
            }
            return length + 1;
        }
        while (low + 1 != hi) {
            int mid = low + (hi - low) / 2;
            if (position <= this.lineEndTable[mid]) {
                hi = mid;
                continue;
            }
            low = mid;
        }
        return low + 2;
    }

    @Override
    int memSize() {
        int size = 72;
        if (this.lineEndTable != null) {
            size += 12 + 4 * this.lineEndTable.length;
        }
        if (this.optionalCommentTable != null) {
            size += 12 + 4 * this.optionalCommentTable.length;
        }
        return size;
    }

    void setCommentTable(Comment[] commentTable) {
        if (commentTable == null) {
            this.optionalCommentList = null;
            this.optionalCommentTable = null;
        } else {
            int nextAvailablePosition = 0;
            int i = 0;
            while (i < commentTable.length) {
                Comment comment = commentTable[i];
                if (comment == null) {
                    throw new IllegalArgumentException();
                }
                int start = comment.getStartPosition();
                int length = comment.getLength();
                if (start < 0 || length < 0 || start < nextAvailablePosition) {
                    throw new IllegalArgumentException();
                }
                nextAvailablePosition = comment.getStartPosition() + comment.getLength();
                ++i;
            }
            this.optionalCommentTable = commentTable;
            List<Comment> commentList = Arrays.asList(commentTable);
            this.optionalCommentList = Collections.unmodifiableList(commentList);
        }
    }

    void setTypeRoot(ITypeRoot typeRoot) {
        this.typeRoot = typeRoot;
    }

    void setLineEndTable(int[] lineEndTable) {
        if (lineEndTable == null) {
            throw new NullPointerException();
        }
        this.checkModifiable();
        this.lineEndTable = lineEndTable;
    }

    public void setModule(ModuleDeclaration module) {
        this.unsupportedBelow9();
        ModuleDeclaration oldChild = this.module;
        this.preReplaceChild(oldChild, module, MODULE_PROPERTY);
        this.module = module;
        this.postReplaceChild(oldChild, module, MODULE_PROPERTY);
    }

    public void setPackage(PackageDeclaration pkgDecl) {
        PackageDeclaration oldChild = this.optionalPackageDeclaration;
        this.preReplaceChild(oldChild, pkgDecl, PACKAGE_PROPERTY);
        this.optionalPackageDeclaration = pkgDecl;
        this.postReplaceChild(oldChild, pkgDecl, PACKAGE_PROPERTY);
    }

    void setProblems(IProblem[] problems) {
        if (problems == null) {
            throw new IllegalArgumentException();
        }
        this.problems = problems;
    }

    void setStatementsRecoveryData(Object data) {
        this.statementsRecoveryData = data;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    int treeSize() {
        int size = this.memSize();
        if (this.module != null) {
            size += this.getModule().treeSize();
        }
        if (this.optionalPackageDeclaration != null) {
            size += this.getPackage().treeSize();
        }
        size += this.imports.listSize();
        size += this.types.listSize();
        if (this.optionalCommentList != null) {
            int i = 0;
            while (i < this.optionalCommentList.size()) {
                Comment comment = (Comment)this.optionalCommentList.get(i);
                if (comment != null && comment.getParent() == null) {
                    size += comment.treeSize();
                }
                ++i;
            }
        }
        return size;
    }

    public List types() {
        return this.types;
    }
}

