/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.IString;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldManyToOne;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldOneToMany;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldString;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.StructDef;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.JavaNames;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeArgument;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeId;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeSignature;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.CharArrayBuffer;
import java.util.List;

public class NdComplexTypeSignature
extends NdTypeSignature {
    public static final FieldString VARIABLE_IDENTIFIER;
    public static final FieldManyToOne<NdTypeId> RAW_TYPE;
    public static final FieldOneToMany<NdTypeArgument> TYPE_ARGUMENTS;
    public static final FieldManyToOne<NdComplexTypeSignature> DECLARING_TYPE;
    public static final FieldOneToMany<NdComplexTypeSignature> DECLARED_TYPES;
    public static final StructDef<NdComplexTypeSignature> type;

    static {
        type = StructDef.create(NdComplexTypeSignature.class, NdTypeSignature.type);
        VARIABLE_IDENTIFIER = type.addString();
        RAW_TYPE = FieldManyToOne.create(type, NdTypeId.USED_AS_COMPLEX_TYPE);
        TYPE_ARGUMENTS = FieldOneToMany.create(type, NdTypeArgument.PARENT);
        DECLARING_TYPE = FieldManyToOne.create(type, null);
        DECLARED_TYPES = FieldOneToMany.create(type, DECLARING_TYPE);
        type.useStandardRefCounting().done();
    }

    public NdComplexTypeSignature(Nd nd) {
        super(nd);
    }

    @Override
    public NdTypeId getRawType() {
        return RAW_TYPE.get(this.getNd(), this.address);
    }

    public void setVariableIdentifier(char[] variableIdentifier) {
        VARIABLE_IDENTIFIER.put(this.getNd(), this.address, variableIdentifier);
    }

    public IString getVariableIdentifier() {
        return VARIABLE_IDENTIFIER.get(this.getNd(), this.address);
    }

    public void setRawType(NdTypeId rawType) {
        RAW_TYPE.put(this.getNd(), this.address, rawType);
    }

    public void setGenericDeclaringType(NdComplexTypeSignature enclosingType) {
        DECLARING_TYPE.put(this.getNd(), this.address, enclosingType);
    }

    public NdComplexTypeSignature getGenericDeclaringType() {
        return DECLARING_TYPE.get(this.getNd(), this.address);
    }

    public List<NdTypeArgument> getTypeArguments() {
        return TYPE_ARGUMENTS.asList(this.getNd(), this.address);
    }

    public NdTypeSignature getArrayDimensionType() {
        if (this.isArrayType()) {
            long size = TYPE_ARGUMENTS.size(this.getNd(), this.address);
            if (size != 1L) {
                throw this.getNd().describeProblem().addProblemAddress(TYPE_ARGUMENTS, this.address).build("Array types should have exactly one argument");
            }
            return TYPE_ARGUMENTS.get(this.getNd(), this.address, 0).getType();
        }
        return null;
    }

    @Override
    public void getSignature(CharArrayBuffer result, boolean includeTrailingSemicolon) {
        NdComplexTypeSignature parentSignature = this.getGenericDeclaringType();
        if (this.isTypeVariable()) {
            result.append('T');
            result.append(this.getVariableIdentifier().getChars());
            if (includeTrailingSemicolon) {
                result.append(';');
            }
            return;
        }
        NdTypeSignature arrayDimension = this.getArrayDimensionType();
        if (arrayDimension != null) {
            result.append('[');
            arrayDimension.getSignature(result);
            return;
        }
        if (parentSignature != null) {
            parentSignature.getSignature(result, false);
            result.append('.');
            char[] simpleName = this.getRawType().getSimpleName().getChars();
            result.append(simpleName);
        } else {
            result.append(this.getRawType().getFieldDescriptorWithoutTrailingSemicolon());
        }
        List<NdTypeArgument> arguments = this.getTypeArguments();
        if (!arguments.isEmpty()) {
            result.append('<');
            for (NdTypeArgument next : arguments) {
                next.getSignature(result);
            }
            result.append('>');
        }
        if (includeTrailingSemicolon) {
            result.append(';');
        }
    }

    public boolean isTypeVariable() {
        return this.getVariableIdentifier().length() != 0;
    }

    public boolean isArrayType() {
        NdTypeId rawType = this.getRawType();
        if (rawType == null) {
            return false;
        }
        return rawType.getFieldDescriptor().comparePrefix(JavaNames.ARRAY_FIELD_DESCRIPTOR_PREFIX, true) == 0;
    }
}

