/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.util;

import java.util.Arrays;

public class CharArrayUtils {
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final char[] EMPTY = EMPTY_CHAR_ARRAY;
    public static final char[][] EMPTY_ARRAY_OF_CHAR_ARRAYS = new char[0][];

    public static final boolean equals(char[] str1, char[] str2) {
        return Arrays.equals(str1, str2);
    }

    public static final boolean equals(char[][] strarr1, char[][] strarr2) {
        if (strarr1 == strarr2) {
            return true;
        }
        if (strarr1 == null || strarr2 == null) {
            return false;
        }
        if (strarr1.length != strarr2.length) {
            return false;
        }
        int i = 0;
        while (i < strarr2.length) {
            if (!Arrays.equals(strarr1[i], strarr2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int compare(char[] str1, char[] str2) {
        if (str1 == str2) {
            return 0;
        }
        int end = Math.min(str1.length, str2.length);
        int i = 0;
        while (i < end) {
            int diff = str1[i] - str2[i];
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return str1.length - str2.length;
    }

    public static final char[] concat(char[] first, char[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[] result = new char[length1 + length2];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static final char[] concat(char[] first, char[] second, char[] third) {
        if (first == null) {
            return CharArrayUtils.concat(second, third);
        }
        if (second == null) {
            return CharArrayUtils.concat(first, third);
        }
        if (third == null) {
            return CharArrayUtils.concat(first, second);
        }
        int length1 = first.length;
        int length2 = second.length;
        int length3 = third.length;
        char[] result = new char[length1 + length2 + length3];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        System.arraycopy(third, 0, result, length1 + length2, length3);
        return result;
    }

    public static final char[] concat(char[] first, char[] second, char[] third, char[] fourth) {
        if (first == null) {
            return CharArrayUtils.concat(second, third, fourth);
        }
        if (second == null) {
            return CharArrayUtils.concat(first, third, fourth);
        }
        if (third == null) {
            return CharArrayUtils.concat(first, second, fourth);
        }
        if (fourth == null) {
            return CharArrayUtils.concat(first, second, third);
        }
        int length1 = first.length;
        int length2 = second.length;
        int length3 = third.length;
        int length4 = fourth.length;
        char[] result = new char[length1 + length2 + length3 + length4];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        System.arraycopy(third, 0, result, length1 + length2, length3);
        System.arraycopy(fourth, 0, result, length1 + length2 + length3, length4);
        return result;
    }

    public static char[] concat(char[] ... toCatenate) {
        int totalSize = 0;
        char[][] cArray = toCatenate;
        int n = toCatenate.length;
        int n2 = 0;
        while (n2 < n) {
            char[] next = cArray[n2];
            totalSize += next.length;
            ++n2;
        }
        char[] result = new char[totalSize];
        int writeIndex = 0;
        char[][] cArray2 = toCatenate;
        int n3 = toCatenate.length;
        int n4 = 0;
        while (n4 < n3) {
            char[] next = cArray2[n4];
            if (next != null) {
                System.arraycopy(next, 0, result, writeIndex, next.length);
                writeIndex += next.length;
            }
            ++n4;
        }
        return result;
    }

    public static final char[][] subarray(char[][] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[][] result = new char[end - start][];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final char[] subarray(char[] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final int indexOf(char toBeFound, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char toBeFound, char[] buffer, int start, int end) {
        if (start < 0 || start > buffer.length || end > buffer.length) {
            return -1;
        }
        int i = start;
        while (i < end) {
            if (toBeFound == buffer[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static char[] subarray(char[] inputString, int index) {
        if (inputString.length <= index) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[inputString.length - index];
        System.arraycopy(inputString, index, result, 0, result.length);
        return result;
    }

    public static boolean startsWith(char[] fieldDescriptor, char c) {
        return fieldDescriptor.length > 0 && fieldDescriptor[0] == c;
    }

    public static char[] notNull(char[] contents) {
        if (contents == null) {
            return EMPTY_CHAR_ARRAY;
        }
        return contents;
    }
}

