/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimplePropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostfixExpression
extends Expression {
    public static final SimplePropertyDescriptor OPERATOR_PROPERTY = new SimplePropertyDescriptor(PostfixExpression.class, "operator", Operator.class, true);
    public static final ChildPropertyDescriptor OPERAND_PROPERTY = new ChildPropertyDescriptor(PostfixExpression.class, "operand", Expression.class, true, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Operator operator = Operator.INCREMENT;
    private Expression operand = null;

    static {
        ArrayList propertyList = new ArrayList(3);
        PostfixExpression.createPropertyList(PostfixExpression.class, propertyList);
        PostfixExpression.addProperty(OPERAND_PROPERTY, propertyList);
        PostfixExpression.addProperty(OPERATOR_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = PostfixExpression.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    PostfixExpression(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return PostfixExpression.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == OPERATOR_PROPERTY) {
            if (get) {
                return this.getOperator();
            }
            this.setOperator((Operator)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == OPERAND_PROPERTY) {
            if (get) {
                return this.getOperand();
            }
            this.setOperand((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 37;
    }

    @Override
    ASTNode clone0(AST target) {
        PostfixExpression result = new PostfixExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOperator(this.getOperator());
        result.setOperand((Expression)this.getOperand().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getOperand());
        }
        visitor.endVisit(this);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(OPERATOR_PROPERTY);
        this.operator = operator;
        this.postValueChange(OPERATOR_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getOperand() {
        if (this.operand == null) {
            PostfixExpression postfixExpression = this;
            synchronized (postfixExpression) {
                if (this.operand == null) {
                    this.preLazyInit();
                    this.operand = new SimpleName(this.ast);
                    this.postLazyInit(this.operand, OPERAND_PROPERTY);
                }
            }
        }
        return this.operand;
    }

    public void setOperand(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.operand;
        this.preReplaceChild(oldChild, expression, OPERAND_PROPERTY);
        this.operand = expression;
        this.postReplaceChild(oldChild, expression, OPERAND_PROPERTY);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.operand == null ? 0 : this.getOperand().treeSize());
    }

    public static class Operator {
        private String token;
        public static final Operator INCREMENT = new Operator("++");
        public static final Operator DECREMENT = new Operator("--");
        private static final Map CODES = new HashMap(20);

        static {
            Operator[] ops = new Operator[]{INCREMENT, DECREMENT};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }
    }
}

