/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.codeassist.complete;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.codeassist.complete.CompletionNodeFound;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.ReferenceExpression;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.TypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.Wildcard;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.Constant;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.BlockScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.parser.Scanner;

public class CompletionOnReferenceExpressionName
extends ReferenceExpression {
    public CompletionOnReferenceExpressionName(Scanner scanner) {
        super(scanner);
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        CompilerOptions compilerOptions = scope.compilerOptions();
        this.constant = Constant.NotAConstant;
        TypeBinding lhsType = this.lhs.resolveType(scope);
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            boolean typeArgumentsHaveErrors = compilerOptions.sourceLevel < 0x310000L;
            this.resolvedTypeArguments = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                TypeReference typeReference = this.typeArguments[i];
                this.resolvedTypeArguments[i] = typeReference.resolveType(scope, true);
                if (this.resolvedTypeArguments[i] == null) {
                    typeArgumentsHaveErrors = true;
                }
                if (typeArgumentsHaveErrors && typeReference instanceof Wildcard) {
                    scope.problemReporter().illegalUsageOfWildcard(typeReference);
                }
                ++i;
            }
            if (typeArgumentsHaveErrors || lhsType == null) {
                throw new CompletionNodeFound();
            }
        }
        if (lhsType != null && lhsType.isValidBinding()) {
            throw new CompletionNodeFound((ASTNode)this, lhsType, scope);
        }
        throw new CompletionNodeFound();
    }

    @Override
    public StringBuffer printExpression(int tab, StringBuffer output) {
        output.append("<CompletionOnReferenceExpressionName:");
        this.lhs.print(0, output);
        output.append("::");
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        output.append(this.selector);
        return output.append('>');
    }
}

