/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.Flags;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IInitializer;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ISourceRange;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.Member;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;

public class Initializer
extends Member
implements IInitializer {
    protected Initializer(JavaElement parent, int count) {
        super(parent);
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        this.occurrenceCount = count;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Initializer)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int getElementType() {
        return 10;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.occurrenceCount);
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '|';
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.occurrenceCount);
    }

    @Override
    public String readableName() {
        return ((JavaElement)((Object)this.getDeclaringType())).readableName();
    }

    @Override
    public ISourceRange getNameRange() {
        return null;
    }

    @Override
    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && ((cu = (CompilationUnit)this.getAncestor(5)) == null || cu.isPrimary())) {
            return this;
        }
        IJavaElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getInitializer(this.occurrenceCount);
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append("<initializer #");
            buffer.append(this.occurrenceCount);
            buffer.append("> (not open)");
        } else if (info == NO_INFO) {
            buffer.append("<initializer #");
            buffer.append(this.occurrenceCount);
            buffer.append(">");
        } else {
            try {
                buffer.append("<");
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                buffer.append("initializer #");
                buffer.append(this.occurrenceCount);
                buffer.append(">");
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

