/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.codeassist.ISearchRequestor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.AccessRestriction;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.AccessRuleSet;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElementRequestor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.NameLookup;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragmentRoot;

class SearchableEnvironmentRequestor
extends JavaElementRequestor {
    protected ISearchRequestor requestor;
    protected ICompilationUnit unitToSkip;
    protected IJavaProject project;
    protected NameLookup nameLookup;
    protected boolean checkAccessRestrictions;

    public SearchableEnvironmentRequestor(ISearchRequestor requestor) {
        this.requestor = requestor;
        this.unitToSkip = null;
        this.project = null;
        this.nameLookup = null;
        this.checkAccessRestrictions = false;
    }

    public SearchableEnvironmentRequestor(ISearchRequestor requestor, ICompilationUnit unitToSkip, IJavaProject project, NameLookup nameLookup) {
        this.requestor = requestor;
        this.unitToSkip = unitToSkip;
        this.project = project;
        this.nameLookup = nameLookup;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.problem.discouragedReference", true));
    }

    @Override
    public void acceptPackageFragment(IPackageFragment packageFragment) {
        this.requestor.acceptPackage(packageFragment.getElementName().toCharArray());
    }

    @Override
    public void acceptModule(IModuleDescription module) {
        this.requestor.acceptModule(module.getElementName().toCharArray());
    }

    @Override
    public void acceptType(IType type) {
        try {
            AccessRuleSet accessRuleSet;
            PackageFragmentRoot root;
            ClasspathEntry entry;
            if (this.unitToSkip != null && this.unitToSkip.equals(type.getCompilationUnit())) {
                return;
            }
            char[] packageName = type.getPackageFragment().getElementName().toCharArray();
            boolean isBinary = type instanceof BinaryType;
            AccessRestriction accessRestriction = null;
            if (this.checkAccessRestrictions && (isBinary || !type.getJavaProject().equals(this.project)) && (entry = (ClasspathEntry)this.nameLookup.rootToResolvedEntries.get(root = (PackageFragmentRoot)type.getAncestor(3))) != null && (accessRuleSet = entry.getAccessRuleSet()) != null) {
                char[][] packageChars = CharOperation.splitOn('.', packageName);
                char[] fileWithoutExtension = type.getElementName().toCharArray();
                accessRestriction = accessRuleSet.getViolatedRestriction(CharOperation.concatWith(packageChars, fileWithoutExtension, '/'));
            }
            this.requestor.acceptType(packageName, type.getElementName().toCharArray(), null, type.getFlags(), accessRestriction);
        }
        catch (JavaModelException javaModelException) {}
    }
}

