/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ArrayCreation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.MethodDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SingleVariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.StructuralPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.dom.util.DOMASTUtil;
import java.util.List;

public class SourceRangeVerifier
extends ASTVisitor {
    public static boolean DEBUG = false;
    public static boolean DEBUG_THROW = false;
    private StringBuffer bugs;

    public String process(ASTNode node) {
        StringBuffer buffer;
        this.bugs = buffer = new StringBuffer();
        node.accept(this);
        this.bugs = null;
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean preVisit2(ASTNode node) {
        ASTNode previous = null;
        List properties = node.structuralPropertiesForType();
        int i = 0;
        while (i < properties.size()) {
            StructuralPropertyDescriptor property = (StructuralPropertyDescriptor)properties.get(i);
            if (property.isChildProperty()) {
                ASTNode child = (ASTNode)node.getStructuralProperty(property);
                if (child != null) {
                    boolean ok = this.checkChild(node, previous, child);
                    if (!ok) return false;
                    previous = child;
                }
            } else if (property.isChildListProperty()) {
                List children = (List)node.getStructuralProperty(property);
                int j = 0;
                while (j < children.size()) {
                    ASTNode child = (ASTNode)children.get(j);
                    boolean ok = this.checkChild(node, previous, child);
                    if (!ok) {
                        return false;
                    }
                    previous = child;
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean checkChild(ASTNode parent, ASTNode previous, ASTNode child) {
        if ((parent.getFlags() & 9) != 0 || (child.getFlags() & 9) != 0) {
            return false;
        }
        if (DOMASTUtil.isRecordDeclarationSupported(child.getAST()) && child instanceof SingleVariableDeclaration && previous != null && previous instanceof MethodDeclaration && ((MethodDeclaration)previous).isCompactConstructor()) {
            return true;
        }
        int parentStart = parent.getStartPosition();
        int parentEnd = parentStart + parent.getLength();
        int childStart = child.getStartPosition();
        int childEnd = childStart + child.getLength();
        if (previous != null) {
            if (child.getLocationInParent() == ArrayCreation.DIMENSIONS_PROPERTY) {
                return false;
            }
            int previousStart = previous.getStartPosition();
            int previousEnd = previousStart + previous.getLength();
            if (childStart < previousEnd) {
                String bug = "- parent [" + parentStart + ", " + parentEnd + "] " + parent.getClass().getName() + '\n' + "   previous [" + previousStart + ", " + previousEnd + "] " + previous.getClass().getName() + '\n' + "   " + child.getLocationInParent().getId() + " [" + childStart + ", " + childEnd + "] " + child.getClass().getName() + '\n';
                this.bugs.append(bug);
            }
        }
        if (parentStart > childStart || childEnd > parentEnd) {
            String bug = "- parent [" + parentStart + ", " + parentEnd + "] " + parent.getClass().getName() + '\n' + "   " + child.getLocationInParent().getId() + " [" + childStart + ", " + childEnd + "] " + child.getClass().getName() + '\n';
            this.bugs.append(bug);
        }
        return true;
    }
}

