/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.NdStruct;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldByte;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldList;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldString;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.StructDef;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeBound;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdTypeSignature;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.CharArrayBuffer;
import java.util.List;

public class NdTypeParameter
extends NdStruct {
    public static final FieldString IDENTIFIER;
    public static final FieldList<NdTypeBound> BOUNDS;
    public static final FieldByte TYPE_PARAMETER_FLAGS;
    public static final StructDef<NdTypeParameter> type;

    static {
        type = StructDef.create(NdTypeParameter.class, NdStruct.type);
        IDENTIFIER = type.addString();
        BOUNDS = FieldList.create(type, NdTypeBound.type);
        TYPE_PARAMETER_FLAGS = type.addByte();
        type.done();
    }

    public void setIdentifier(char[] identifier) {
        IDENTIFIER.put(this.getNd(), this.address, identifier);
    }

    public char[] getIdentifier() {
        return IDENTIFIER.get(this.getNd(), this.address).getChars();
    }

    public void setFirstBoundIsClass(boolean isClass) {
        this.setFlag((byte)1, isClass);
    }

    public boolean isFirstBoundAClass() {
        return (TYPE_PARAMETER_FLAGS.get(this.getNd(), this.address) & 1) != 0;
    }

    private void setFlag(byte flag, boolean value) {
        byte oldValue = TYPE_PARAMETER_FLAGS.get(this.getNd(), this.address);
        byte newValue = value ? (byte)(oldValue | flag) : (byte)(oldValue & ~flag);
        TYPE_PARAMETER_FLAGS.put(this.getNd(), this.address, newValue);
    }

    public List<NdTypeBound> getBounds() {
        return BOUNDS.asList(this.getNd(), this.address);
    }

    public void getSignature(CharArrayBuffer result) {
        result.append(this.getIdentifier());
        List<NdTypeBound> bounds = this.getBounds();
        if (!bounds.isEmpty() && !this.isFirstBoundAClass()) {
            result.append(':');
        }
        for (NdTypeBound next : bounds) {
            next.getSignature(result);
        }
    }

    public static void getSignature(CharArrayBuffer buffer, List<NdTypeParameter> params) {
        if (!params.isEmpty()) {
            buffer.append('<');
            for (NdTypeParameter next : params) {
                next.getSignature(buffer);
            }
            buffer.append('>');
        }
    }

    public void createBound(NdTypeSignature boundSignature) {
        BOUNDS.append(this.getNd(), this.getAddress()).setType(boundSignature);
    }

    public void allocateBounds(int numBounds) {
        BOUNDS.allocate(this.getNd(), this.getAddress(), numBounds);
    }
}

