/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElementDelta;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.IJavaSearchScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.AbstractSearchScope;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class UnindexedSearchScope
extends AbstractSearchScope {
    private IJavaSearchScope searchScope;

    private UnindexedSearchScope(IJavaSearchScope scope) {
        this.searchScope = scope;
    }

    public static IJavaSearchScope filterEntriesCoveredByTheNewIndex(IJavaSearchScope scope) {
        return new UnindexedSearchScope(scope);
    }

    @Override
    public boolean encloses(String resourcePathString) {
        int separatorIndex = resourcePathString.indexOf("|");
        if (separatorIndex != -1) {
            return false;
        }
        if (this.isJarFile(resourcePathString)) {
            return false;
        }
        return this.searchScope.encloses(resourcePathString);
    }

    private boolean isJarFile(String possibleJarFile) {
        if (possibleJarFile == null) {
            return false;
        }
        return possibleJarFile.endsWith(".jar") || possibleJarFile.endsWith(".JAR");
    }

    @Override
    public boolean encloses(IJavaElement element) {
        try {
            IResource underlyingResource = element.getUnderlyingResource();
            if (underlyingResource != null && this.isJarFile(underlyingResource.getName())) {
                return false;
            }
        }
        catch (JavaModelException e) {
            JavaCore.getPlugin().getLog().log(e.getStatus());
        }
        return this.searchScope.encloses(element);
    }

    @Override
    public IPath[] enclosingProjectsAndJars() {
        IPath[] unfiltered = this.searchScope.enclosingProjectsAndJars();
        ArrayList<IPath> result = new ArrayList<IPath>();
        IPath[] iPathArray = unfiltered;
        int n = unfiltered.length;
        int n2 = 0;
        while (n2 < n) {
            IPath next = iPathArray[n2];
            if (!this.isJarFile(next.lastSegment())) {
                result.add(next);
            }
            ++n2;
        }
        return result.toArray(new IPath[result.size()]);
    }

    @Override
    public void processDelta(IJavaElementDelta delta, int eventType) {
        if (this.searchScope instanceof AbstractSearchScope) {
            AbstractSearchScope inner = (AbstractSearchScope)this.searchScope;
            inner.processDelta(delta, eventType);
        }
    }

    @Override
    public boolean isParallelSearchSupported() {
        return true;
    }
}

