/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.matching;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.SearchPattern;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.index.EntryResult;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.index.Index;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.matching.JavaSearchPattern;
import java.io.IOException;

public class ModulePattern
extends JavaSearchPattern {
    boolean findDeclarations = true;
    boolean findReferences = true;
    char[] name;
    protected static char[][] REF_CATEGORIES = new char[][]{MODULE_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{MODULE_REF, MODULE_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{MODULE_DECL};
    private static char[] regexPrefix = new char[]{'/', 'r', ' '};

    public static char[] createIndexKey(char[] name) {
        return name;
    }

    protected ModulePattern(int matchRule) {
        super(8192, matchRule);
    }

    public ModulePattern(char[] name, int limitTo, int matchRule) {
        this(ModulePattern.trapDoorRegexMatchRule(name, matchRule));
        this.name = ModulePattern.trapDoorRegexExtractModuleName(name);
        switch (limitTo & 0xF) {
            case 0: {
                this.findReferences = false;
                break;
            }
            case 2: {
                this.findDeclarations = false;
                break;
            }
            case 3: {
                if ((this.getMatchRule() & 4) == 0) break;
                this.findReferences = false;
            }
        }
        this.mustResolve = this.mustResolve();
    }

    private static char[] trapDoorRegexExtractModuleName(char[] name2) {
        int index = CharOperation.indexOf(regexPrefix, name2, false);
        return index >= 0 ? CharOperation.subarray(name2, index + regexPrefix.length, name2.length) : name2;
    }

    private static int trapDoorRegexMatchRule(char[] name2, int matchRule) {
        return CharOperation.indexOf(regexPrefix, name2, false) == 0 ? 4 : matchRule;
    }

    @Override
    public void decodeIndexKey(char[] key) {
        this.name = key;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new ModulePattern(0);
    }

    @Override
    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return this.matchesName(this.name, ((ModulePattern)decodedPattern).name);
    }

    @Override
    public EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.name;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.name != null) {
                    key = ModulePattern.createIndexKey(this.name);
                    break;
                }
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.name == null) break;
                key = ModulePattern.createIndexKey(this.name);
                break;
            }
            case 4: {
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    protected boolean mustResolve() {
        return true;
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "ModuleCombinedPattern: " : "ModuleDeclarationPattern: ");
        } else {
            output.append("ModuleReferencePattern: ");
        }
        output.append("module ");
        output.append(this.name);
        return super.print(output);
    }
}

