/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.matching;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ITypeParameter;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.IJavaSearchScope;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.SearchParticipant;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.AccessRuleSet;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.index.Index;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.IndexQueryRequestor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.JavaSearchScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.matching.JavaSearchPattern;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class TypeParameterPattern
extends JavaSearchPattern {
    protected boolean findDeclarations;
    protected boolean findReferences;
    protected char[] name;
    protected ITypeParameter typeParameter;
    protected char[] declaringMemberName;
    protected char[] methodDeclaringClassName;
    protected char[][] methodArgumentTypes;

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        JavaSearchScope javaSearchScope;
        AccessRuleSet access;
        String documentPath;
        String relativePath;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.typeParameter.getAncestor(3);
        if (root.isArchive()) {
            IType type = (IType)this.typeParameter.getAncestor(7);
            relativePath = String.valueOf(type.getFullyQualifiedName('$').replace('.', '/')) + ".class";
            IModuleDescription md = root.getModuleDescription();
            if (md != null) {
                String module = md.getElementName();
                documentPath = root.getPath() + "|" + module + "|" + relativePath;
            } else {
                documentPath = root.getPath() + "|" + relativePath;
            }
        } else {
            IPath path = this.typeParameter.getPath();
            documentPath = path.toString();
            relativePath = Util.relativePath(path, 1);
        }
        if (scope instanceof JavaSearchScope ? (access = (javaSearchScope = (JavaSearchScope)scope).getAccessRuleSet(relativePath, index.containerPath)) != JavaSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch(documentPath, this, participant, access) : scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, this, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "TypeParamCombinedPattern: " : "TypeParamDeclarationPattern: ");
        } else {
            output.append("TypeParamReferencePattern: ");
        }
        output.append(this.typeParameter.toString());
        return super.print(output);
    }
}

