/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CategorizedProblem;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.CompilationResult;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.DefaultErrorHandlingPolicies;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.CompilationUnitDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.ConstructorDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.batch.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.problem.DefaultProblemFactory;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.problem.ProblemReporter;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.CommentRecorderParser;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.RecordedParsingInformation;
import java.util.Locale;
import java.util.Map;

public class CodeSnippetParsingUtil {
    public RecordedParsingInformation recordedParsingInformation;
    public boolean ignoreMethodBodies;

    public CodeSnippetParsingUtil(boolean ignoreMethodBodies) {
        this.ignoreMethodBodies = ignoreMethodBodies;
    }

    public CodeSnippetParsingUtil() {
        this(false);
    }

    private RecordedParsingInformation getRecordedParsingInformation(CompilationResult compilationResult, int[][] commentPositions) {
        int problemsCount = compilationResult.problemCount;
        CategorizedProblem[] problems = null;
        if (problemsCount != 0) {
            CategorizedProblem[] compilationResultProblems = compilationResult.problems;
            if (compilationResultProblems.length == problemsCount) {
                problems = compilationResultProblems;
            } else {
                problems = new CategorizedProblem[problemsCount];
                System.arraycopy(compilationResultProblems, 0, problems, 0, problemsCount);
            }
        }
        return new RecordedParsingInformation(problems, compilationResult.getLineSeparatorPositions(), commentPositions);
    }

    public ASTNode[] parseClassBodyDeclarations(char[] source, int offset, int length, Map<String, String> settings, boolean recordParsingInformation, boolean enabledStatementRecovery) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        compilerOptions.ignoreMethodBodies = this.ignoreMethodBodies;
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CommentRecorderParser parser = new CommentRecorderParser(problemReporter, false);
        parser.setMethodsFullRecovery(false);
        parser.setStatementsRecovery(enabledStatementRecovery);
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = new CompilationUnitDeclaration(problemReporter, compilationResult, source.length);
        ASTNode[] result = parser.parseClassBodyDeclarations(source, offset, length, compilationUnitDeclaration);
        if (recordParsingInformation) {
            this.recordedParsingInformation = this.getRecordedParsingInformation(compilationResult, compilationUnitDeclaration.comments);
        }
        return result;
    }

    public Expression parseExpression(char[] source, int offset, int length, Map<String, String> settings, boolean recordParsingInformation) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CommentRecorderParser parser = new CommentRecorderParser(problemReporter, false);
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = new CompilationUnitDeclaration(problemReporter, compilationResult, source.length);
        Expression result = parser.parseExpression(source, offset, length, unit, true);
        if (recordParsingInformation) {
            this.recordedParsingInformation = this.getRecordedParsingInformation(compilationResult, unit.comments);
        }
        return result;
    }

    public ConstructorDeclaration parseStatements(char[] source, int offset, int length, Map<String, String> settings, boolean recordParsingInformation, boolean enabledStatementRecovery) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault()));
        CommentRecorderParser parser = new CommentRecorderParser(problemReporter, false);
        parser.setMethodsFullRecovery(false);
        parser.setStatementsRecovery(enabledStatementRecovery);
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration compilationUnitDeclaration = new CompilationUnitDeclaration(problemReporter, compilationResult, length);
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(compilationResult);
        constructorDeclaration.sourceEnd = -1;
        constructorDeclaration.declarationSourceEnd = offset + length - 1;
        constructorDeclaration.bodyStart = offset;
        constructorDeclaration.bodyEnd = offset + length - 1;
        parser.scanner.setSource(compilationResult);
        parser.scanner.resetTo(offset, offset + length);
        parser.parse(constructorDeclaration, compilationUnitDeclaration, true);
        if (recordParsingInformation) {
            this.recordedParsingInformation = this.getRecordedParsingInformation(compilationResult, compilationUnitDeclaration.comments);
        }
        return constructorDeclaration;
    }
}

