/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util;

import io.spring.javaformat.eclipse.jdt.jdk8.core.util.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.IConstantPool;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.INestMemberAttributeEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.util.INestMembersAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.ClassFileAttribute;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.NestMembersAttributeEntry;

public class NestMembersAttribute
extends ClassFileAttribute
implements INestMembersAttribute {
    private static final INestMemberAttributeEntry[] NO_ENTRIES = new INestMemberAttributeEntry[0];
    private int nestMembers;
    private INestMemberAttributeEntry[] entries;

    public NestMembersAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length = this.nestMembers = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.entries = new INestMemberAttributeEntry[length];
            int i = 0;
            while (i < length) {
                this.entries[i] = new NestMembersAttributeEntry(classFileBytes, constantPool, offset + readOffset);
                readOffset += 2;
                ++i;
            }
        } else {
            this.entries = NO_ENTRIES;
        }
    }

    @Override
    public INestMemberAttributeEntry[] getNestMemberAttributesEntries() {
        return this.entries;
    }
}

